/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.store.AndesBatchUpdateException;
import org.wso2.andes.store.AndesTransactionRollbackException;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;
import org.wso2.andes.tools.utils.MessageTracer;

public class MessageWriter
implements StoreHealthListener {
    private static Log log = LogFactory.getLog(MessageWriter.class);
    private final List<AndesMessage> previouslyFailedMessageList;
    private volatile boolean messageStoresUnavailable;
    private final MessagingEngine messagingEngine;

    public MessageWriter(MessagingEngine messagingEngine, int messageBatchSize) {
        this.messagingEngine = messagingEngine;
        this.previouslyFailedMessageList = new ArrayList<AndesMessage>(messageBatchSize);
        this.messageStoresUnavailable = false;
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    public void writeMessages(List<AndesMessage> messageList, Map<String, AndesMessage> retainMap) throws Exception {
        if (this.messageStoresUnavailable) {
            this.handleStoreFailure(messageList);
        } else {
            if (!this.previouslyFailedMessageList.isEmpty()) {
                log.info((Object)("Attempting to store previously failed list of messages of size: " + this.previouslyFailedMessageList.size()));
                try {
                    this.messagingEngine.messagesReceived(this.previouslyFailedMessageList);
                }
                catch (AndesException ex) {
                    log.error((Object)"errors encountered while persisting previously failed messages batch,  this incident will result messages being lost", (Throwable)ex);
                }
                this.previouslyFailedMessageList.clear();
            }
            try {
                if (!messageList.isEmpty()) {
                    this.messagingEngine.messagesReceived(messageList);
                }
                if (!retainMap.isEmpty()) {
                    this.messagingEngine.storeRetainedMessages(retainMap);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(messageList.size() + " messages received from disruptor."));
                }
                if (MessageTracer.isEnabled()) {
                    for (AndesMessage message : messageList) {
                        MessageTracer.trace(message, "content written to database");
                    }
                }
                if (log.isTraceEnabled()) {
                    StringBuilder messageIDsString = new StringBuilder();
                    for (AndesMessage message : messageList) {
                        messageIDsString.append(message.getMetadata().getMessageID()).append(" , ");
                    }
                    log.trace((Object)(messageList.size() + " messages written : " + messageIDsString));
                }
            }
            catch (AndesBatchUpdateException batchInsertEx) {
                log.error((Object)String.format("Unable to store messages, probably due to errors in message stores.success inserts: %d, failed inserts: %d", batchInsertEx.getSuccessfullBatches().size(), batchInsertEx.getFailedBatches().size()), (Throwable)batchInsertEx);
                this.handleStoreFailure(messageList);
                throw batchInsertEx;
            }
            catch (AndesTransactionRollbackException transRollbackEx) {
                log.warn((Object)("Unable to store messages, since transaction rollback. opertation will be reattempted. messages count : " + messageList.size()));
                this.handleStoreFailure(messageList);
                throw transRollbackEx;
            }
            catch (Exception ex) {
                log.warn((Object)("Unable to store messages, due to errors in message stores. operatation will be reattempted. messages count : " + messageList.size()));
                this.handleStoreFailure(messageList);
                throw ex;
            }
        }
    }

    private void handleStoreFailure(List<AndesMessage> messageList) {
        this.previouslyFailedMessageList.addAll(messageList);
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.info((Object)String.format("Message store became nonoperational. messages to store : %d", this.previouslyFailedMessageList.size()));
        this.messageStoresUnavailable = true;
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)String.format("Message store became operational. messages to store : %d", this.previouslyFailedMessageList.size()));
        this.messageStoresUnavailable = false;
    }
}

