/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class MessagePreProcessor
implements EventHandler<InboundEventContainer> {
    private static final Log log = LogFactory.getLog(MessagePreProcessor.class);
    private final MessageIDGenerator idGenerator = new MessageIDGenerator();
    private final ArrayList<AndesMessage> messageList = new ArrayList();

    public void onEvent(InboundEventContainer inboundEvent, long sequence, boolean endOfBatch) throws Exception {
        InboundEventContainer.Type eventType = inboundEvent.getEventType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ sequence " + sequence + "] Event type " + (Object)((Object)eventType)));
        }
        switch (eventType) {
            case MESSAGE_EVENT: {
                AndesMessage message = inboundEvent.popMessage();
                this.updateRoutingInformation(inboundEvent, message, sequence);
                break;
            }
            case TRANSACTION_COMMIT_EVENT: {
                this.preProcessTransaction(inboundEvent, sequence);
                break;
            }
            case DTX_ONE_PHASE_COMMIT_EVENT: 
            case DTX_COMMIT_EVENT: {
                this.preProcessDtxCommit(inboundEvent);
                break;
            }
            case DTX_ROLLBACK_EVENT: {
                this.preProcessDtxRollback(inboundEvent);
                break;
            }
            case SAFE_ZONE_DECLARE_EVENT: {
                this.setSafeZoneLimit(inboundEvent, sequence);
                break;
            }
            case PUBLISHER_RECOVERY_EVENT: {
                inboundEvent.setRecoveryEventMessageId(this.idGenerator.getNextId());
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("[ sequence " + sequence + "] Unhandled event " + inboundEvent.eventInfo()));
            }
        }
    }

    private void preProcessDtxRollback(InboundEventContainer eventContainer) {
        List<AndesPreparedMessageMetadata> dequeueList = eventContainer.getDtxBranch().getMessagesToRestore();
        for (AndesPreparedMessageMetadata messageMetadata : dequeueList) {
            messageMetadata.setMessageID(this.idGenerator.getNextId());
        }
    }

    private void preProcessDtxCommit(InboundEventContainer eventContainer) {
        ArrayList<AndesMessage> clonedMessages = new ArrayList<AndesMessage>();
        ArrayList<AndesMessage> enqueueList = eventContainer.getDtxBranch().getEnqueueList();
        for (AndesMessage message : enqueueList) {
            this.setMessageID(message);
            clonedMessages.addAll(this.preProcessIncomingMessage(eventContainer, message));
        }
        eventContainer.getDtxBranch().setMessagesToStore(clonedMessages);
    }

    private void preProcessTransaction(InboundEventContainer eventContainer, long sequence) throws AndesException {
        Queue<AndesMessage> messageList = eventContainer.getTransactionEvent().getQueuedMessages();
        for (AndesMessage message : messageList) {
            this.updateRoutingInformation(eventContainer, message, sequence);
        }
        eventContainer.getTransactionEvent().setMessagesToStore(eventContainer.getMessageList());
    }

    private void setSafeZoneLimit(InboundEventContainer event, long sequence) {
        long safeZoneLimit = this.idGenerator.getNextId();
        event.setSafeZoneLimit(safeZoneLimit);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ Sequence " + sequence + " ] Pre processing message. Setting the Safe Zone " + safeZoneLimit));
        }
    }

    private void updateRoutingInformation(InboundEventContainer event, AndesMessage message, long sequence) {
        AndesChannel andesChannel = event.getChannel();
        this.setMessageID(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ Sequence " + sequence + " ] Pre processing message. Message ID " + message.getMetadata().getMessageID()));
        }
        List<AndesMessage> messages = this.preProcessIncomingMessage(event, message);
        for (AndesMessage andesMessage : messages) {
            event.addMessage(andesMessage, andesChannel);
        }
    }

    private List<AndesMessage> preProcessIncomingMessage(InboundEventContainer event, AndesMessage message) {
        boolean isMessageRouted = false;
        String messageRouterName = message.getMetadata().getMessageRouterName();
        AndesMessageRouter messageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(messageRouterName);
        Set<StorageQueue> matchingQueues = messageRouter.getMatchingStorageQueues(message);
        this.messageList.clear();
        boolean originalMessageConsumed = false;
        for (StorageQueue matchingQueue : matchingQueues) {
            if (!originalMessageConsumed) {
                message.getMetadata().setStorageQueueName(matchingQueue.getName());
                this.messageList.add(message);
                originalMessageConsumed = true;
            } else {
                AndesMessage clonedMessage = this.cloneAndesMessageMetadataAndContent(message);
                clonedMessage.getMetadata().setStorageQueueName(matchingQueue.getName());
                if (clonedMessage.getMetadata().isCompressed()) {
                    clonedMessage.getMetadata().updateMetadata(true);
                }
                if (MessageTracer.isEnabled()) {
                    MessageTracer.trace(message, "cloned with message id" + clonedMessage.getMetadata().getMessageID() + " for " + clonedMessage.getMetadata().getStorageQueueName());
                }
                this.messageList.add(clonedMessage);
            }
            isMessageRouted = true;
        }
        if (message.getMetadata().isRetain()) {
            event.retainMessage = message;
        }
        if (!isMessageRouted) {
            event.pubAckHandler.ack(message.getMetadata());
            Meter ackMeter = MetricManager.meter((String)"org.wso2.mb.ack.sent", (Level[])new Level[]{Level.INFO});
            ackMeter.mark();
            this.messageList.clear();
            log.info((Object)("Message routing key: " + message.getMetadata().getDestination() + " No routes in cluster. Ignoring Message id " + message.getMetadata().getMessageID()));
        }
        return this.messageList;
    }

    private AndesMessage cloneAndesMessageMetadataAndContent(AndesMessage message) {
        long newMessageId = this.idGenerator.getNextId();
        AndesMessageMetadata clonedMetadata = message.getMetadata().shallowCopy(newMessageId);
        AndesMessage clonedMessage = new AndesMessage(clonedMetadata);
        List<AndesMessagePart> messageParts = message.getContentChunkList();
        for (AndesMessagePart messagePart : messageParts) {
            clonedMessage.addMessagePart(messagePart.shallowCopy(newMessageId));
        }
        return clonedMessage;
    }

    private void setMessageID(AndesMessage message) {
        long messageId = this.idGenerator.getNextId();
        message.getMetadata().setMessageID(messageId);
        if (MessageTracer.isEnabled()) {
            MessageTracer.trace(messageId, message.getMetadata().getDestination(), "mapped to andes message");
        }
        for (AndesMessagePart messagePart : message.getContentChunkList()) {
            messagePart.setMessageID(messageId);
        }
    }

    private static class MessageIDGenerator {
        private static final long REFERENCE_START = 1292976000000L;
        private int uniqueIdForNode = 0;
        private long lastTimestamp = 0L;
        private long lastID = 0L;
        private int offset = 0;

        MessageIDGenerator() {
        }

        long getNextId() {
            this.uniqueIdForNode = ClusterResourceHolder.getInstance().getClusterManager().getUniqueIdForLocalNode();
            long ts = System.currentTimeMillis();
            this.offset = ts == this.lastTimestamp ? ++this.offset : 0;
            this.lastTimestamp = ts;
            long id = (ts - 1292976000000L) * 256L * 1024L + (long)(this.uniqueIdForNode * 1024) + (long)this.offset;
            if (this.lastID == id) {
                throw new RuntimeException("duplicate ids detected. This should never happen");
            }
            this.lastID = id;
            return id;
        }
    }
}

