/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.List;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.disruptor.compression.LZ4CompressionHelper;
import org.wso2.andes.kernel.disruptor.inbound.ContentCompressionStrategy;
import org.wso2.andes.kernel.disruptor.inbound.ContentPartHolder;

public class LZ4ContentCompressionStrategy
implements ContentCompressionStrategy {
    LZ4CompressionHelper lz4CompressionHelper;

    public LZ4ContentCompressionStrategy(LZ4CompressionHelper lz4CompressionHelper) {
        this.lz4CompressionHelper = lz4CompressionHelper;
    }

    @Override
    public ContentPartHolder ContentChunkStrategy(AndesMessage message) {
        return this.compressChunks(message);
    }

    ContentPartHolder compressChunks(AndesMessage message) {
        List<AndesMessagePart> partList = message.getContentChunkList();
        AndesMessageMetadata metadata = message.getMetadata();
        int contentLength = metadata.getMessageContentLength();
        int originalContentLength = contentLength;
        if (originalContentLength > this.lz4CompressionHelper.getContentCompressionThreshold()) {
            AndesMessagePart compressedMessagePart = this.lz4CompressionHelper.getCompressedMessage(partList, originalContentLength);
            metadata.updateMetadata(true);
            message.setMetadata(metadata);
            contentLength = compressedMessagePart.getDataLength();
            partList.clear();
            partList.add(compressedMessagePart);
        }
        ContentPartHolder partHolder = new ContentPartHolder(partList, contentLength);
        return partHolder;
    }
}

