/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.slot.SlotMessageCounter;

public class InboundTransactionEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundTransactionEvent.class);
    private final InboundEventManager eventManager;
    private EventType eventType;
    private SettableFuture<Boolean> taskCompleted;
    private ConcurrentLinkedQueue<AndesMessage> messageQueue;
    private final MessagingEngine messagingEngine;
    private final int maxBatchSize;
    private int currentBatchSize;
    private final AndesChannel channel;
    private final long txWaitTimeout;
    private boolean messagesStoredNotCommitted;

    Queue<AndesMessage> getQueuedMessages() {
        return this.messageQueue;
    }

    void setQueue(ConcurrentLinkedQueue<AndesMessage> queue) {
        this.messageQueue = queue;
    }

    void setMessagesToStore(Collection<AndesMessage> messages) {
        this.messageQueue.clear();
        this.messageQueue.addAll(messages);
    }

    public void enqueueMessage(AndesMessage message) {
        this.messageQueue.add(message);
    }

    public InboundTransactionEvent(MessagingEngine messagingEngine, InboundEventManager eventManager, int maxBatchSize, long txWaitTimeout, AndesChannel channel) {
        this.messagingEngine = messagingEngine;
        this.eventManager = eventManager;
        this.messageQueue = new ConcurrentLinkedQueue();
        this.taskCompleted = SettableFuture.create();
        this.maxBatchSize = maxBatchSize;
        this.channel = channel;
        this.txWaitTimeout = txWaitTimeout;
    }

    public void commit() throws AndesException {
        if (this.currentBatchSize > this.maxBatchSize) {
            this.currentBatchSize = 0;
            this.messageQueue.clear();
            throw new AndesException("Current enqueued batch size exceeds maximum transactional batch size of " + this.maxBatchSize + " bytes.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare for commit. Channel id: " + this.channel.getId()));
        }
        this.eventType = EventType.TX_COMMIT_EVENT;
        this.taskCompleted = SettableFuture.create();
        this.eventManager.requestTransactionCommitEvent(this, this.channel);
        this.waitForCompletion();
    }

    public void rollback() throws AndesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare for rollback. Channel: " + this.channel.getId()));
        }
        this.eventType = EventType.TX_ROLLBACK_EVENT;
        this.taskCompleted = SettableFuture.create();
        this.eventManager.requestTransactionRollbackEvent(this, this.channel);
        this.waitForCompletion();
    }

    public void preProcessEnqueue(AndesMessage message) {
        this.currentBatchSize += message.getMetadata().getMessageContentLength();
        if (this.currentBatchSize > this.maxBatchSize) {
            this.messageQueue.clear();
        } else {
            this.eventManager.requestTransactionEnqueueEvent(message, this, this.channel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enqueue message with message id " + message.getMetadata().getMessageID() + " for transaction "));
            }
        }
    }

    public void close() throws AndesException {
        this.eventType = EventType.TX_CLOSE_EVENT;
        this.taskCompleted = SettableFuture.create();
        this.eventManager.requestTransactionCloseEvent(this, this.channel);
        this.waitForCompletion();
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case TX_COMMIT_EVENT: {
                this.executeCommitEvent();
                break;
            }
            case TX_ROLLBACK_EVENT: {
                this.executeRollbackEvent();
                break;
            }
            case TX_CLOSE_EVENT: {
                this.executeCloseEvent();
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Event " + (Object)((Object)this.eventType) + " ignored."));
            }
        }
    }

    @Override
    public String eventInfo() {
        return "Event type " + (Object)((Object)this.eventType);
    }

    private void executeCloseEvent() throws AndesException {
        try {
            this.messageQueue.clear();
            this.currentBatchSize = 0;
            this.taskCompleted.set((Object)true);
        }
        catch (Throwable t) {
            this.taskCompleted.setException(t);
            this.messageQueue.clear();
            throw new AndesException("Exception occurred while closing transactional channel " + this.channel.getId(), t);
        }
    }

    private void executeCommitEvent() throws AndesException {
        try {
            this.messagesStoredNotCommitted = true;
            SlotMessageCounter.getInstance().recordMetadataCountInSlot(this.getQueuedMessages());
            this.messageQueue.clear();
            this.messagesStoredNotCommitted = false;
            this.currentBatchSize = 0;
            this.taskCompleted.set((Object)true);
        }
        catch (Throwable t) {
            this.taskCompleted.setException(t);
            throw new AndesException("Exception occurred while committing transaction. Channel id " + this.channel.getId(), t);
        }
    }

    private void executeRollbackEvent() throws AndesException {
        try {
            if (this.messagesStoredNotCommitted) {
                ArrayList<AndesMessageMetadata> messagesToRemove = new ArrayList<AndesMessageMetadata>();
                for (AndesMessage message : this.messageQueue) {
                    messagesToRemove.add(message.getMetadata());
                }
                this.messagingEngine.deleteMessages((Collection<AndesMessageMetadata>)messagesToRemove);
                this.messagesStoredNotCommitted = false;
            }
            this.messageQueue.clear();
            this.currentBatchSize = 0;
            this.taskCompleted.set((Object)true);
        }
        catch (Throwable t) {
            this.taskCompleted.setException(t);
            throw new AndesException("Exception occurred while rolling back transaction. Channel id " + this.channel.getId(), t);
        }
    }

    private Boolean waitForCompletion() throws AndesException {
        try {
            return (Boolean)this.taskCompleted.get(this.txWaitTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            String errMsg = "Error occurred while processing transaction event " + (Object)((Object)this.eventType);
            log.error((Object)errMsg, (Throwable)e);
            throw new AndesException(errMsg, e);
        }
        catch (TimeoutException e) {
            String errMsg = (Object)((Object)this.eventType) + " Timeout. Didn't complete within " + this.txWaitTimeout + " seconds.";
            log.error((Object)errMsg, (Throwable)e);
            throw new AndesException(errMsg, e);
        }
        return false;
    }

    private static enum EventType {
        TX_COMMIT_EVENT,
        TX_ROLLBACK_EVENT,
        TX_CLOSE_EVENT;

    }
}

