/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.SubscriptionException;

public class InboundSubscriptionSyncEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundSubscriptionSyncEvent.class);
    private EventType eventType;
    private SettableFuture<Boolean> future = SettableFuture.create();
    private AndesSubscriptionManager subscriptionManager;
    private String encodedSubscriptionEventInfo;

    public InboundSubscriptionSyncEvent(String encodedSubscription) {
        this.encodedSubscriptionEventInfo = encodedSubscription;
    }

    public String getEncodedSubscription() {
        return this.encodedSubscriptionEventInfo;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case SYNC_SUBSCRIPTION_CREATE_EVENT: {
                this.handleOpenSubscriptionEvent();
                break;
            }
            case SYNC_SUBSCRIPTION_CLOSE_EVENT: {
                this.handleCloseSubscriptionEvent();
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    private void handleCloseSubscriptionEvent() {
        boolean isComplete = false;
        try {
            this.subscriptionManager.closeRemoteSubscription(this);
            isComplete = true;
        }
        catch (AndesException e) {
            this.future.setException((Throwable)e);
        }
        finally {
            this.future.set((Object)isComplete);
        }
    }

    private void handleOpenSubscriptionEvent() {
        boolean isComplete = false;
        try {
            this.subscriptionManager.addRemoteSubscription(this);
            isComplete = true;
        }
        catch (SubscriptionException e) {
            this.future.setException((Throwable)e);
        }
        finally {
            this.future.set((Object)isComplete);
        }
    }

    public void prepareForRemoteSubscriptionAdd(AndesSubscriptionManager subscriptionManager) {
        this.eventType = EventType.SYNC_SUBSCRIPTION_CREATE_EVENT;
        this.subscriptionManager = subscriptionManager;
    }

    public void prepareForRemoteSubscriptionClose(AndesSubscriptionManager subscriptionManager) {
        this.eventType = EventType.SYNC_SUBSCRIPTION_CLOSE_EVENT;
        this.subscriptionManager = subscriptionManager;
    }

    public boolean waitForCompletion() throws SubscriptionAlreadyExistsException {
        try {
            return (Boolean)this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SubscriptionAlreadyExistsException) {
                throw (SubscriptionAlreadyExistsException)e.getCause();
            }
            log.warn((Object)("Error occurred while processing event '" + (Object)((Object)this.eventType) + "' for subscriber " + this.encodedSubscriptionEventInfo), (Throwable)e);
        }
        return false;
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public static enum EventType {
        SYNC_SUBSCRIPTION_CREATE_EVENT,
        SYNC_SUBSCRIPTION_CLOSE_EVENT;

    }
}

