/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.SubscriptionAlreadyExistsException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.SubscriberConnection;

public class InboundSubscriptionEvent
implements AndesInboundStateEvent {
    private Runnable postOpenSubscriptionAction;
    private static Log log = LogFactory.getLog(InboundSubscriptionEvent.class);
    private EventType eventType;
    private SettableFuture<Boolean> future = SettableFuture.create();
    private AndesSubscriptionManager subscriptionManager;
    private SubscriberConnection subscriberConnection;
    private ProtocolType protocol;
    private String subscriptionIdentifier;
    private String boundStorageQueueName;
    private String routingKey;

    public Runnable getPostOpenSubscriptionAction() {
        return this.postOpenSubscriptionAction;
    }

    public InboundSubscriptionEvent(ProtocolType protocol, String subscriptionIdentifier, String boundStorageQueueName, String routingKey, SubscriberConnection subscription, Runnable sendConsumeOk) {
        this.protocol = protocol;
        this.subscriptionIdentifier = subscriptionIdentifier;
        this.boundStorageQueueName = boundStorageQueueName;
        this.routingKey = routingKey;
        this.subscriberConnection = subscription;
        this.postOpenSubscriptionAction = sendConsumeOk;
    }

    public InboundSubscriptionEvent(ProtocolType protocol, String subscriptionIdentifier, String boundStorageQueueName, String routingKey, SubscriberConnection subscription) {
        this.protocol = protocol;
        this.subscriptionIdentifier = subscriptionIdentifier;
        this.boundStorageQueueName = boundStorageQueueName;
        this.routingKey = routingKey;
        this.subscriberConnection = subscription;
        this.postOpenSubscriptionAction = new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public SubscriberConnection getSubscriber() {
        return this.subscriberConnection;
    }

    public String getBoundStorageQueueName() {
        return this.boundStorageQueueName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public ProtocolType getProtocol() {
        return this.protocol;
    }

    public String getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case OPEN_SUBSCRIPTION_EVENT: {
                this.handleOpenSubscriptionEvent();
                break;
            }
            case CLOSE_SUBSCRIPTION_EVENT: {
                this.handleCloseSubscriptionEvent();
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    private void handleCloseSubscriptionEvent() {
        boolean isComplete = false;
        try {
            this.subscriptionManager.closeLocalSubscription(this);
            isComplete = true;
        }
        catch (AndesException e) {
            this.future.setException((Throwable)e);
        }
        finally {
            this.future.set((Object)isComplete);
        }
    }

    private void handleOpenSubscriptionEvent() {
        boolean isComplete = false;
        try {
            this.subscriptionManager.addLocalSubscription(this);
            isComplete = true;
        }
        catch (AndesException e) {
            this.future.setException((Throwable)e);
        }
        finally {
            this.future.set((Object)isComplete);
        }
    }

    public void prepareForNewSubscription(AndesSubscriptionManager subscriptionManager) {
        this.eventType = EventType.OPEN_SUBSCRIPTION_EVENT;
        this.subscriptionManager = subscriptionManager;
    }

    public void prepareForCloseSubscription(AndesSubscriptionManager subscriptionManager) {
        this.eventType = EventType.CLOSE_SUBSCRIPTION_EVENT;
        this.subscriptionManager = subscriptionManager;
    }

    public boolean waitForCompletion() throws AndesException {
        try {
            return (Boolean)this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable originalException = e.getCause();
            if (originalException instanceof SubscriptionAlreadyExistsException) {
                throw (SubscriptionAlreadyExistsException)originalException;
            }
            if (originalException instanceof AndesException) {
                throw (AndesException)originalException;
            }
            log.warn((Object)("Error occurred while processing event '" + (Object)((Object)this.eventType) + "' for channel id " + this.subscriberConnection.getProtocolChannelID()), originalException);
        }
        return false;
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public static enum EventType {
        OPEN_SUBSCRIPTION_EVENT,
        CLOSE_SUBSCRIPTION_EVENT;

    }
}

