/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class InboundQueueSyncEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundQueueEvent.class);
    private String encodedQueueInfo;
    private EventType eventType;
    private AndesContextInformationManager contextInformationManager;
    private SettableFuture<Integer> purgedCount;
    private SettableFuture<Boolean> isEventComplete;

    public InboundQueueSyncEvent(String encodedQueueInfo) {
        this.encodedQueueInfo = encodedQueueInfo;
        this.purgedCount = SettableFuture.create();
        this.isEventComplete = SettableFuture.create();
    }

    public StorageQueue toStorageQueue() {
        return new StorageQueue(this.encodedQueueInfo);
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case SYNC_QUEUE_CREATE_EVENT: {
                this.contextInformationManager.syncQueueCreate(this);
                this.isEventComplete.set((Object)true);
                break;
            }
            case SYNC_QUEUE_DELETE_EVENT: {
                this.contextInformationManager.syncQueueDelete(this);
                break;
            }
            case SYNC_QUEUE_PURGE_EVENT: {
                this.handlePurgeEvent();
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    private void handlePurgeEvent() {
        int count = 0;
        try {
            this.contextInformationManager.handleQueuePurgeNotification(this);
            this.purgedCount.set((Object)count);
        }
        catch (AndesException e) {
            this.purgedCount.setException((Throwable)e);
        }
        finally {
            this.purgedCount.set((Object)count);
        }
    }

    public void prepareForSyncCreateQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.SYNC_QUEUE_CREATE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void prepareForSyncDeleteQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.SYNC_QUEUE_DELETE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void prepareForSyncPurgeQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.SYNC_QUEUE_PURGE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    private static enum EventType {
        SYNC_QUEUE_PURGE_EVENT,
        IS_QUEUE_DELETABLE_EVENT,
        SYNC_QUEUE_DELETE_EVENT,
        SYNC_QUEUE_CREATE_EVENT;

    }
}

