/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class InboundQueueEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundQueueEvent.class);
    private EventType eventType;
    private AndesContextInformationManager contextInformationManager;
    private SettableFuture<Integer> purgedCount;
    private SettableFuture<Boolean> isEventComplete;
    private String queueName;
    private boolean isDurable;
    private boolean isShared;
    private String queueOwner;
    private boolean isExclusive;

    public InboundQueueEvent(String queueName, boolean isDurable, boolean isShared, String queueOwner, boolean isExclusive) {
        this.queueName = queueName;
        this.isDurable = isDurable;
        this.isShared = isShared;
        this.queueOwner = queueOwner;
        this.isExclusive = isExclusive;
        this.purgedCount = SettableFuture.create();
        this.isEventComplete = SettableFuture.create();
    }

    public StorageQueue toStorageQueue() {
        return new StorageQueue(this.queueName, this.isDurable, this.isShared, this.queueOwner, this.isExclusive);
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case CREATE_QUEUE_EVENT: {
                this.isEventComplete.set((Object)true);
                break;
            }
            case DELETE_QUEUE_EVENT: {
                this.handleQueueDeleteEvent();
                break;
            }
            case QUEUE_PURGE_EVENT: {
                this.handlePurgeEvent();
                break;
            }
            case IS_QUEUE_DELETABLE_EVENT: {
                this.handleIsQueueDeletableEvent();
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    private void handleIsQueueDeletableEvent() {
        boolean queueDeletable = false;
        try {
            queueDeletable = this.contextInformationManager.checkIfQueueDeletable(this.queueName);
        }
        catch (AndesException e) {
            this.isEventComplete.setException((Throwable)e);
        }
        finally {
            this.isEventComplete.set((Object)queueDeletable);
        }
    }

    private void handleQueueDeleteEvent() {
        boolean isComplete = false;
        try {
            this.contextInformationManager.deleteQueue(this.toStorageQueue());
            isComplete = true;
        }
        catch (AndesException e) {
            this.isEventComplete.setException((Throwable)e);
        }
        finally {
            this.isEventComplete.set((Object)isComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePurgeEvent() {
        boolean isComplete = false;
        int count = -1;
        try {
            count = this.contextInformationManager.handleQueuePurge(this);
            this.purgedCount.set((Object)count);
            isComplete = true;
        }
        catch (AndesException e) {
            this.purgedCount.setException((Throwable)e);
        }
        finally {
            this.purgedCount.set((Object)count);
            this.isEventComplete.set((Object)isComplete);
        }
    }

    public void prepareForCreateQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.CREATE_QUEUE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void prepareForDeleteQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.DELETE_QUEUE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void purgeQueue(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.QUEUE_PURGE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public Integer getPurgedCount(long timeout, TimeUnit timeUnit) throws AndesException, TimeoutException {
        try {
            return (Integer)this.purgedCount.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AndesException("Error while purging queue " + this.queueName, e);
        }
        return -1;
    }

    public void prepareForCheckIfQueueDeletable(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.IS_QUEUE_DELETABLE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public boolean IsQueueDeletable() throws AndesException {
        try {
            return (Boolean)this.isEventComplete.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AndesException("Error occurred while checking is queue: " + this.queueName + " deletable", e);
        }
        return false;
    }

    public void waitForCompletion() throws AndesException {
        try {
            this.isEventComplete.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.warn((Object)("Error occurred while processing event " + (Object)((Object)this.eventType) + " queue: " + this.queueName));
        }
    }

    private static enum EventType {
        QUEUE_PURGE_EVENT,
        IS_QUEUE_DELETABLE_EVENT,
        DELETE_QUEUE_EVENT,
        CREATE_QUEUE_EVENT;

    }
}

