/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.tools.utils.MessageTracer;

public class InboundMessageRejectEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundMessageRejectEvent.class);
    private EventType eventType;
    private long messageId;
    private UUID channelId;
    private boolean reQueue;
    private boolean isMessageBeyondLastRollback;

    public InboundMessageRejectEvent(long messageId, UUID channelId, boolean reQueue) {
        this.messageId = messageId;
        this.channelId = channelId;
        this.reQueue = reQueue;
    }

    public void prepareToRejectMessage(boolean isMessageBeyondLastRollback) {
        this.isMessageBeyondLastRollback = isMessageBeyondLastRollback;
        this.eventType = EventType.MESSAGE_REJECT_EVENT;
    }

    @Override
    public void updateState() throws AndesException {
        AndesSubscription subscription = AndesContext.getInstance().getAndesSubscriptionManager().getSubscriptionByProtocolChannel(this.channelId);
        if (subscription != null) {
            DeliverableAndesMetadata rejectedMessage = subscription.onMessageReject(this.messageId, this.reQueue, this.isMessageBeyondLastRollback);
            MessageTracer.trace(rejectedMessage, "message rejected");
        } else {
            log.warn((Object)("Cannot handle reject. Subscription not found for channel " + this.channelId + "Dropping message id= " + this.messageId));
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public static enum EventType {
        MESSAGE_REJECT_EVENT;

    }
}

