/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.subscription.AndesSubscription;

public class InboundMessageRecoveryEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundMessageRecoveryEvent.class);
    private EventType eventType;
    private UUID channelID;
    private DisruptorEventCallback recoverOKCallback;

    public InboundMessageRecoveryEvent(UUID channelID, DisruptorEventCallback recoverOKCallback) {
        this.recoverOKCallback = recoverOKCallback;
        this.channelID = channelID;
        this.eventType = EventType.CHANNEL_RECOVER_EVENT;
    }

    @Override
    public void updateState() throws AndesException {
        AndesSubscription subscription = AndesContext.getInstance().getAndesSubscriptionManager().getSubscriptionByProtocolChannel(this.channelID);
        if (null != subscription) {
            subscription.recoverMessages();
        } else {
            log.warn((Object)("Cannot handle recover. No subscriptions found for channel " + this.channelID));
        }
        this.recoverOKCallback.execute();
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public static enum EventType {
        CHANNEL_RECOVER_EVENT;

    }
}

