/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.List;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesMessage;

public class InboundMessageList {
    private List<AndesMessage> messageList = new ArrayList<AndesMessage>();

    InboundMessageList() {
    }

    public void registerClear(AndesChannel channel) {
        channel.recordRemovalFromBuffer(InboundMessageList.getTotalChunkCount(this.messageList));
        this.clear();
    }

    public void clear() {
        this.messageList.clear();
    }

    public void registerAddMessage(AndesMessage message, AndesChannel channel) {
        channel.recordAdditionToBuffer(message.getContentChunkList().size());
        this.messageList.add(message);
    }

    public AndesMessage registerPopMessage(int index, AndesChannel channel) {
        AndesMessage message = this.messageList.remove(index);
        channel.recordRemovalFromBuffer(message.getContentChunkList().size());
        return message;
    }

    public List<AndesMessage> getMessageList() {
        return this.messageList;
    }

    private static int getTotalChunkCount(List<AndesMessage> messages) {
        int count = 0;
        for (AndesMessage message : messages) {
            count += message.getContentChunkList().size();
        }
        return count;
    }
}

