/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.andes.kernel.FlowControlManager;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventManager;
import org.wso2.andes.kernel.dtx.DtxRegistry;
import org.wso2.andes.kernel.slot.SlotDeletionExecutor;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.registry.ApplicationRegistry;

public class InboundKernelOpsEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundKernelOpsEvent.class);
    private EventType eventType;
    private MessagingEngine messagingEngine;
    private SettableFuture<Boolean> taskStatus;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateState() throws AndesException {
        Boolean taskComplete = false;
        try {
            switch (this.eventType) {
                case STOP_MESSAGE_DELIVERY_EVENT: {
                    this.stopMessageDelivery();
                    taskComplete = true;
                    return;
                }
                case START_MESSAGE_DELIVERY_EVENT: {
                    this.startMessageDelivery();
                    taskComplete = true;
                    return;
                }
                default: {
                    log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
                    return;
                }
            }
        }
        catch (Throwable t) {
            this.taskStatus.setException(t);
            throw new AndesException("Exception occurred while processing " + (Object)((Object)this.eventType), t);
        }
        finally {
            this.taskStatus.set((Object)taskComplete);
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void startMessageDelivery() {
        this.messagingEngine.startMessageDelivery();
    }

    public void stopMessageDelivery() {
        this.messagingEngine.stopMessageDelivery();
    }

    public void shutdownMessagingEngine() {
        try {
            this.messagingEngine.close();
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted while closing messaging engine. ", (Throwable)e);
        }
    }

    public void completePendingMessageStoringOperations() {
        this.messagingEngine.completePendingStoreOperations();
    }

    public void prepareForStartMessageDelivery(MessagingEngine messagingEngine) {
        this.eventType = EventType.START_MESSAGE_DELIVERY_EVENT;
        this.messagingEngine = messagingEngine;
        this.taskStatus = SettableFuture.create();
    }

    public void prepareForStopMessageDelivery(MessagingEngine messagingEngine) {
        this.eventType = EventType.STOP_MESSAGE_DELIVERY_EVENT;
        this.messagingEngine = messagingEngine;
        this.taskStatus = SettableFuture.create();
    }

    public void prepareForStartMessageExpirationWorker(MessagingEngine messagingEngine) {
        this.eventType = EventType.START_EXPIRATION_WORKER_EVENT;
        this.messagingEngine = messagingEngine;
        this.taskStatus = SettableFuture.create();
    }

    public void prepareForStopMessageExpirationWorker(MessagingEngine messagingEngine) {
        this.eventType = EventType.STOP_EXPIRATION_WORKER_EVENT;
        this.messagingEngine = messagingEngine;
        this.taskStatus = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown(MessagingEngine messagingEngine, InboundEventManager inboundEventManager, FlowControlManager flowControlManager, DtxRegistry dtxRegistry) throws AndesException {
        Boolean taskComplete = false;
        this.messagingEngine = messagingEngine;
        this.taskStatus = SettableFuture.create();
        try {
            flowControlManager.prepareChannelsForShutdown();
            dtxRegistry.stop();
            this.stopMessageDelivery();
            ApplicationRegistry.remove();
            inboundEventManager.stop();
            ClusterResourceHolder.getInstance().getClusterManager().prepareLocalNodeForShutDown();
            AndesKernelBoot.stopHouseKeepingThreads();
            this.completePendingMessageStoringOperations();
            SlotDeletionExecutor.getInstance().stopSlotDeletionExecutor();
            if (AndesContext.getInstance().isClusteringEnabled() && AndesContext.getInstance().getClusterAgent().isCoordinator()) {
                AndesKernelBoot.stopThriftServer();
                SlotManagerClusterMode.getInstance().shutDownSlotManager();
                AndesContext.getInstance().getClusterAgent().stop();
            }
            AndesKernelBoot.shutDownAndesClusterEventSynchronization();
            AndesContext.getInstance().getAndesContextStore().close();
            taskComplete = true;
        }
        finally {
            this.taskStatus.set((Object)taskComplete);
        }
    }

    public Boolean waitForTaskCompletion() throws AndesException {
        try {
            return (Boolean)this.taskStatus.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AndesException("Error occurred while processing event " + (Object)((Object)this.eventType), e);
        }
        return false;
    }

    public static enum EventType {
        STOP_MESSAGE_DELIVERY_EVENT,
        START_MESSAGE_DELIVERY_EVENT,
        SHUTDOWN_MESSAGING_ENGINE_EVENT,
        START_EXPIRATION_WORKER_EVENT,
        STOP_EXPIRATION_WORKER_EVENT;

    }
}

