/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;

public class InboundExchangeSyncEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundExchangeSyncEvent.class);
    private EventType eventType;
    private String encodedExchangeInfo;
    private AndesContextInformationManager contextInformationManager;

    public InboundExchangeSyncEvent(String exchangeInfo) {
        this.encodedExchangeInfo = exchangeInfo;
    }

    public String getEncodedExchangeInfo() {
        return this.encodedExchangeInfo;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case SYNC_EXCHANGE_CREATE_EVENT: {
                this.contextInformationManager.syncExchangeCreate(this);
                break;
            }
            case SYNC_EXCHANGE_DELETE_EVENT: {
                this.contextInformationManager.syncExchangeDelete(this);
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForCreateExchangeSync(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.SYNC_EXCHANGE_CREATE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void prepareForDeleteExchangeSync(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.SYNC_EXCHANGE_DELETE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    private static enum EventType {
        SYNC_EXCHANGE_CREATE_EVENT,
        SYNC_EXCHANGE_DELETE_EVENT;

    }
}

