/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;

public class InboundExchangeEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundExchangeEvent.class);
    private String messageRouterName;
    private String type;
    private boolean autoDelete;
    private EventType eventType;
    private AndesContextInformationManager contextInformationManager;

    public InboundExchangeEvent(String messageRouterName, String type, boolean autoDelete) {
        this.messageRouterName = messageRouterName;
        this.type = type;
        this.autoDelete = autoDelete;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public String getType() {
        return this.type;
    }

    public String getMessageRouterName() {
        return this.messageRouterName;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case CREATE_EXCHANGE_EVENT: {
                this.contextInformationManager.createExchange(this);
                break;
            }
            case DELETE_EXCHANGE_EVENT: {
                this.contextInformationManager.deleteExchange(this);
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForCreateExchange(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.CREATE_EXCHANGE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    public void prepareForDeleteExchange(AndesContextInformationManager contextInformationManager) {
        this.eventType = EventType.DELETE_EXCHANGE_EVENT;
        this.contextInformationManager = contextInformationManager;
    }

    private static enum EventType {
        CREATE_EXCHANGE_EVENT,
        DELETE_EXCHANGE_EVENT;

    }
}

