/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesAckEvent;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.DisablePubAckImpl;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.ConcurrentBatchEventHandler;
import org.wso2.andes.kernel.disruptor.InboundEventHandler;
import org.wso2.andes.kernel.disruptor.LogExceptionHandler;
import org.wso2.andes.kernel.disruptor.compression.LZ4CompressionHelper;
import org.wso2.andes.kernel.disruptor.inbound.AckEventBatchHandler;
import org.wso2.andes.kernel.disruptor.inbound.AckHandler;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.ContentChunkHandler;
import org.wso2.andes.kernel.disruptor.inbound.DisabledContentCompressionStrategy;
import org.wso2.andes.kernel.disruptor.inbound.DtxDbWriter;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.disruptor.inbound.InboundMessageRecoveryEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundTransactionEvent;
import org.wso2.andes.kernel.disruptor.inbound.LZ4ContentCompressionStrategy;
import org.wso2.andes.kernel.disruptor.inbound.MessagePreProcessor;
import org.wso2.andes.kernel.disruptor.inbound.MessageWriter;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.kernel.disruptor.inbound.StateEventHandler;
import org.wso2.andes.kernel.disruptor.waitStrategy.SleepingBlockingWaitStrategy;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;

public class InboundEventManager {
    private static Log log = LogFactory.getLog(InboundEventManager.class);
    private final RingBuffer<InboundEventContainer> ringBuffer;
    private AtomicInteger ackedMessageCount = new AtomicInteger();
    private Disruptor<InboundEventContainer> disruptor;
    private final DisablePubAckImpl disablePubAck;
    private LZ4CompressionHelper lz4CompressionHelper;

    public InboundEventManager(MessagingEngine messagingEngine) {
        int turn;
        Integer bufferSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PUBLISHING_BUFFER_SIZE);
        Integer writeHandlerCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PARALLEL_MESSAGE_WRITERS);
        Integer ackHandlerCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_ACK_HANDLER_COUNT);
        Integer writerBatchSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MESSAGE_WRITER_BATCH_SIZE);
        Integer ackHandlerBatchSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_ACKNOWLEDGEMENT_HANDLER_BATCH_SIZE);
        Integer transactionHandlerCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PARALLEL_TRANSACTION_MESSAGE_WRITERS);
        Integer dtxDbWriterCount = 1;
        this.disablePubAck = new DisablePubAckImpl();
        int maxContentChunkSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_CONTENT_CHUNK_SIZE);
        int contentChunkHandlerCount = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_CONTENT_CHUNK_HANDLER_COUNT);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("DisruptorInboundEventThread-%d").build();
        ExecutorService executorPool = Executors.newCachedThreadPool(namedThreadFactory);
        this.disruptor = new Disruptor(InboundEventContainer.getFactory(), bufferSize.intValue(), (Executor)executorPool, ProducerType.MULTI, (WaitStrategy)new SleepingBlockingWaitStrategy());
        this.disruptor.handleExceptionsWith((ExceptionHandler)new LogExceptionHandler());
        EventHandler[] batchEventHandlers = new InboundEventHandler[writeHandlerCount + transactionHandlerCount + ackHandlerCount + dtxDbWriterCount];
        this.lz4CompressionHelper = new LZ4CompressionHelper();
        EventHandler[] chunkHandlers = new ContentChunkHandler[contentChunkHandlerCount];
        for (int i = 0; i < contentChunkHandlerCount; ++i) {
            chunkHandlers[i] = this.lz4CompressionHelper.isCompressionEnabled() ? new ContentChunkHandler(maxContentChunkSize, new LZ4ContentCompressionStrategy(this.lz4CompressionHelper)) : new ContentChunkHandler(maxContentChunkSize, new DisabledContentCompressionStrategy());
        }
        for (turn = 0; turn < writeHandlerCount; ++turn) {
            batchEventHandlers[turn] = new ConcurrentBatchEventHandler(turn, writeHandlerCount, writerBatchSize, InboundEventContainer.Type.MESSAGE_EVENT, new MessageWriter(messagingEngine, writerBatchSize));
        }
        for (turn = 0; turn < transactionHandlerCount; ++turn) {
            batchEventHandlers[writeHandlerCount.intValue() + turn] = new ConcurrentBatchEventHandler(turn, transactionHandlerCount, writerBatchSize, InboundEventContainer.Type.TRANSACTION_COMMIT_EVENT, new MessageWriter(messagingEngine, writerBatchSize));
        }
        for (turn = 0; turn < ackHandlerCount; ++turn) {
            batchEventHandlers[writeHandlerCount.intValue() + transactionHandlerCount.intValue() + turn] = new AckEventBatchHandler(turn, ackHandlerCount, ackHandlerBatchSize, new AckHandler(messagingEngine));
        }
        for (turn = 0; turn < dtxDbWriterCount; ++turn) {
            batchEventHandlers[writeHandlerCount.intValue() + transactionHandlerCount.intValue() + ackHandlerCount.intValue() + turn] = new DtxDbWriter(messagingEngine, turn, dtxDbWriterCount);
        }
        MessagePreProcessor preProcessor = new MessagePreProcessor();
        StateEventHandler stateEventHandler = new StateEventHandler();
        this.disruptor.handleEventsWith(chunkHandlers).then(new EventHandler[]{preProcessor});
        this.disruptor.after(new EventHandler[]{preProcessor}).handleEventsWith(batchEventHandlers).then(new EventHandler[]{stateEventHandler});
        this.ringBuffer = this.disruptor.start();
        MetricManager.gauge((String)"org.wso2.mb.inbound.disruptor.message.count", (Level)Level.INFO, (Gauge)new InBoundRingGauge());
        MetricManager.gauge((String)"org.wso2.mb.inbound.disruptor.ack.count", (Level)Level.INFO, (Gauge)new AckedMessageCountGauge());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(AndesMessage message, AndesChannel andesChannel, PubAckHandler pubAckHandler) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.MESSAGE_EVENT);
            event.setChannel(andesChannel);
            event.addMessage(message, andesChannel);
            event.pubAckHandler = pubAckHandler;
        }
        finally {
            this.ringBuffer.publish(sequence);
            MessageTracer.trace(message, "messaging event submitted to inbound disruptor");
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ sequence: " + sequence + " ] Message published to disruptor. Message id: " + message.getMetadata().getMessageID()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackReceived(AndesAckData ackData) {
        this.ackedMessageCount.getAndIncrement();
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.ACKNOWLEDGEMENT_EVENT);
            event.ackData = new AndesAckEvent(ackData);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (MessageTracer.isEnabled()) {
                MessageTracer.traceAck(ackData, "ACK event submitted to disruptor");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ sequence: " + sequence + " ] Message acknowledgement published to disruptor. Message id " + ackData.getMessageId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishStateEvent(AndesInboundStateEvent stateEvent) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.STATE_CHANGE_EVENT);
            event.setStateEvent(stateEvent);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] State change event '" + stateEvent.eventInfo() + "' published to Disruptor"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlotDeletionSafeZone() {
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.SAFE_ZONE_DECLARE_EVENT);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)event.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishRecoveryEvent() {
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.PUBLISHER_RECOVERY_EVENT);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)event.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishMessageRecoveryEvent(InboundMessageRecoveryEvent recoveryEvent) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer event = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            event.setEventType(InboundEventContainer.Type.MESSAGE_RECOVERY_EVENT);
            event.setMessageRecoveryEvent(recoveryEvent);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)event.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTransactionEnqueueEvent(AndesMessage message, InboundTransactionEvent transactionEvent, AndesChannel channel) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer eventContainer = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            eventContainer.setEventType(InboundEventContainer.Type.TRANSACTION_ENQUEUE_EVENT);
            eventContainer.setTransactionEvent(transactionEvent);
            eventContainer.setChannel(channel);
            eventContainer.addMessage(message, channel);
            eventContainer.pubAckHandler = this.disablePubAck;
        }
        finally {
            this.ringBuffer.publish(sequence);
            MessageTracer.traceTransaction(message, channel, "enqueue event submitted to inbound disruptor");
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)eventContainer.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    public void requestTransactionCommitEvent(InboundTransactionEvent transactionEvent, AndesChannel channel) {
        this.requestTransactionEvent(transactionEvent, InboundEventContainer.Type.TRANSACTION_COMMIT_EVENT, channel);
        MessageTracer.traceTransaction(channel, transactionEvent.getQueuedMessages().size(), "transaction commit event submitted to inbound disruptor");
    }

    public void requestTransactionRollbackEvent(InboundTransactionEvent transactionEvent, AndesChannel channel) {
        this.requestTransactionEvent(transactionEvent, InboundEventContainer.Type.TRANSACTION_ROLLBACK_EVENT, channel);
        MessageTracer.traceTransaction(channel, transactionEvent.getQueuedMessages().size(), "transaction rollback event submitted to inbound disruptor");
    }

    public void requestTransactionCloseEvent(InboundTransactionEvent transactionEvent, AndesChannel channel) {
        this.requestTransactionEvent(transactionEvent, InboundEventContainer.Type.TRANSACTION_CLOSE_EVENT, channel);
        MessageTracer.traceTransaction(channel, transactionEvent.getQueuedMessages().size(), "transaction close event submitted to inbound disruptor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestTransactionEvent(InboundTransactionEvent transactionEvent, InboundEventContainer.Type eventType, AndesChannel channel) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer eventContainer = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            eventContainer.setEventType(eventType);
            eventContainer.setTransactionEvent(transactionEvent);
            eventContainer.pubAckHandler = this.disablePubAck;
            eventContainer.setChannel(channel);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)eventContainer.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    public void stop() {
        this.disruptor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDtxEvent(DtxBranch dtxBranch, AndesChannel channel, InboundEventContainer.Type type) {
        long sequence = this.ringBuffer.next();
        InboundEventContainer eventContainer = (InboundEventContainer)this.ringBuffer.get(sequence);
        try {
            eventContainer.setEventType(type);
            eventContainer.setDtxBranch(dtxBranch);
            eventContainer.pubAckHandler = this.disablePubAck;
            eventContainer.setChannel(channel);
        }
        finally {
            this.ringBuffer.publish(sequence);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ Sequence: " + sequence + " ] " + (Object)((Object)eventContainer.getEventType()) + "' published to Disruptor"));
            }
        }
    }

    private class AckedMessageCountGauge
    implements Gauge<Integer> {
        private AckedMessageCountGauge() {
        }

        public Integer getValue() {
            return InboundEventManager.this.ackedMessageCount.getAndSet(0);
        }
    }

    private class InBoundRingGauge
    implements Gauge<Long> {
        private InBoundRingGauge() {
        }

        public Long getValue() {
            return (long)InboundEventManager.this.ringBuffer.getBufferSize() - InboundEventManager.this.ringBuffer.remainingCapacity();
        }
    }
}

