/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.lmax.disruptor.EventFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.andes.kernel.AndesAckEvent;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundMessageList;
import org.wso2.andes.kernel.disruptor.inbound.InboundMessageRecoveryEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundTransactionEvent;
import org.wso2.andes.kernel.disruptor.inbound.PubAckHandler;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.kernel.slot.SlotMessageCounter;

public class InboundEventContainer {
    private AndesChannel channel;
    private long safeZoneLimit;
    private Type eventType;
    private AndesInboundStateEvent stateEvent;
    private InboundMessageList messageList;
    private long recoveryEventMessageId;
    public AndesAckEvent ackData;
    private final AtomicBoolean freshContent;
    public PubAckHandler pubAckHandler;
    private InboundTransactionEvent transactionEvent;
    public AndesMessage retainMessage;
    private DtxBranch dtxBranch;
    private Throwable error;
    private InboundMessageRecoveryEvent recoverEvent;

    public long getRecoveryEventMessageId() {
        return this.recoveryEventMessageId;
    }

    public void setRecoveryEventMessageId(long recoveryEventMessageId) {
        this.recoveryEventMessageId = recoveryEventMessageId;
    }

    public void setDtxBranch(DtxBranch dtxBranch) {
        this.dtxBranch = dtxBranch;
    }

    public DtxBranch getDtxBranch() {
        return this.dtxBranch;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean hasErrorOccurred() {
        return this.error != null;
    }

    public void setMessageRecoveryEvent(InboundMessageRecoveryEvent recoveryEvent) {
        this.recoverEvent = recoveryEvent;
    }

    public InboundEventContainer() {
        this.setMessageList(new InboundMessageList());
        this.eventType = Type.IGNORE_EVENT;
        this.safeZoneLimit = Long.MIN_VALUE;
        this.freshContent = new AtomicBoolean(true);
    }

    public final Type getEventType() {
        return this.eventType;
    }

    public final void setEventType(Type eventType) {
        this.eventType = eventType;
    }

    public void updateState() throws AndesException {
        switch (this.eventType) {
            case STATE_CHANGE_EVENT: {
                this.stateEvent.updateState();
                break;
            }
            case TRANSACTION_COMMIT_EVENT: 
            case TRANSACTION_ROLLBACK_EVENT: 
            case TRANSACTION_CLOSE_EVENT: {
                this.getTransactionEvent().updateState();
                break;
            }
            case DTX_PREPARE_EVENT: 
            case DTX_COMMIT_EVENT: 
            case DTX_ONE_PHASE_COMMIT_EVENT: 
            case DTX_ROLLBACK_EVENT: {
                this.getDtxBranch().updateState(this);
                break;
            }
            case PUBLISHER_RECOVERY_EVENT: {
                this.executeRecoveryEvent();
                break;
            }
            case MESSAGE_RECOVERY_EVENT: {
                this.recoverEvent.updateState();
                break;
            }
        }
    }

    private void executeRecoveryEvent() {
        SlotMessageCounter.getInstance().sendRecoverySlotSubmit(this.getRecoveryEventMessageId());
    }

    public void setStateEvent(AndesInboundStateEvent stateEvent) {
        this.stateEvent = stateEvent;
    }

    public void clear() {
        this.channel = null;
        this.messageList.clear();
        this.retainMessage = null;
        this.ackData = null;
        this.stateEvent = null;
        this.eventType = Type.IGNORE_EVENT;
        this.pubAckHandler = null;
        this.setTransactionEvent(null);
        this.transactionEvent = null;
        this.freshContent.set(true);
        this.dtxBranch = null;
        this.error = null;
        this.recoverEvent = null;
    }

    public boolean availableForContentProcessing() {
        return this.freshContent.compareAndSet(true, false);
    }

    public void addMessage(AndesMessage message) {
        this.messageList.registerAddMessage(message, this.channel);
    }

    public void addMessage(AndesMessage message, AndesChannel channel) {
        this.messageList.registerAddMessage(message, channel);
    }

    public String eventInfo() {
        if (this.eventType == Type.STATE_CHANGE_EVENT) {
            return this.stateEvent.eventInfo();
        }
        return this.eventType.toString();
    }

    public InboundTransactionEvent getTransactionEvent() {
        return this.transactionEvent;
    }

    public void setTransactionEvent(InboundTransactionEvent transactionEvent) {
        this.transactionEvent = transactionEvent;
    }

    public List<AndesMessage> getMessageList() {
        return this.messageList.getMessageList();
    }

    public AndesMessage popMessage() {
        return this.messageList.registerPopMessage(0, this.channel);
    }

    public void setMessageList(InboundMessageList messageList) {
        this.messageList = messageList;
    }

    public void clearMessageList(AndesChannel andesChannel) {
        this.messageList.registerClear(andesChannel);
    }

    public AndesChannel getChannel() {
        return this.channel;
    }

    public void setChannel(AndesChannel channel) {
        this.channel = channel;
    }

    public void setSafeZoneLimit(long safeZoneLimit) {
        this.safeZoneLimit = safeZoneLimit;
    }

    public long getSafeZoneLimit() {
        return this.safeZoneLimit;
    }

    public static EventFactory<InboundEventContainer> getFactory() {
        return new InboundEventFactory();
    }

    public static class InboundEventFactory
    implements EventFactory<InboundEventContainer> {
        public InboundEventContainer newInstance() {
            return new InboundEventContainer(){};
        }
    }

    public static enum Type {
        MESSAGE_EVENT,
        TRANSACTION_ENQUEUE_EVENT,
        TRANSACTION_COMMIT_EVENT,
        TRANSACTION_ROLLBACK_EVENT,
        TRANSACTION_CLOSE_EVENT,
        ACKNOWLEDGEMENT_EVENT,
        STATE_CHANGE_EVENT,
        IGNORE_EVENT,
        SAFE_ZONE_DECLARE_EVENT,
        PUBLISHER_RECOVERY_EVENT,
        MESSAGE_RECOVERY_EVENT,
        DTX_PREPARE_EVENT,
        DTX_COMMIT_EVENT,
        DTX_ONE_PHASE_COMMIT_EVENT,
        DTX_ROLLBACK_EVENT;

    }
}

