/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;

public class InboundDeleteMessagesEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundDeleteMessagesEvent.class);
    private EventType eventType;
    private List<DeliverableAndesMetadata> deliverableAndesMetadataList;
    private Collection<AndesMessageMetadata> andesMessageMetadataList;
    private boolean moveToDLC;
    private MessagingEngine messagingEngine;

    public InboundDeleteMessagesEvent(List<DeliverableAndesMetadata> messagesToRemove, boolean moveToDLC) {
        this.deliverableAndesMetadataList = messagesToRemove;
        this.andesMessageMetadataList = new ArrayList<AndesMessageMetadata>(0);
        this.moveToDLC = moveToDLC;
    }

    public InboundDeleteMessagesEvent(Collection<AndesMessageMetadata> messagesToRemove, boolean moveToDLC) {
        this.deliverableAndesMetadataList = new ArrayList<DeliverableAndesMetadata>(0);
        this.andesMessageMetadataList = messagesToRemove;
        this.moveToDLC = moveToDLC;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case DELETE_MESSAGES_EVENT: {
                if (!this.deliverableAndesMetadataList.isEmpty()) {
                    if (!this.moveToDLC) {
                        this.messagingEngine.deleteMessages(this.deliverableAndesMetadataList);
                        break;
                    }
                    this.messagingEngine.moveMessageToDeadLetterChannel(this.deliverableAndesMetadataList);
                    break;
                }
                if (!this.moveToDLC) {
                    this.messagingEngine.deleteMessages(this.andesMessageMetadataList);
                    break;
                }
                this.messagingEngine.moveMessageToDeadLetterChannel(this.andesMessageMetadataList);
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForDelete(MessagingEngine messagingEngine) {
        this.eventType = EventType.DELETE_MESSAGES_EVENT;
        this.messagingEngine = messagingEngine;
    }

    private static enum EventType {
        DELETE_MESSAGES_EVENT;

    }
}

