/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundDeleteMessagesEvent;

public class InboundDeleteDLCMessagesEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundDeleteMessagesEvent.class);
    private EventType eventType;
    private List<AndesMessageMetadata> andesMessageMetadataList;
    private MessagingEngine messagingEngine;

    public InboundDeleteDLCMessagesEvent(List<AndesMessageMetadata> messagesToRemove) {
        this.andesMessageMetadataList = messagesToRemove;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case DELETE_DLC_MESSAGES_EVENT: {
                this.messagingEngine.deleteDLCMessages(this.andesMessageMetadataList);
                break;
            }
            default: {
                log.error((Object)("Event type not set properly " + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForDelete(MessagingEngine messagingEngine) {
        this.eventType = EventType.DELETE_DLC_MESSAGES_EVENT;
        this.messagingEngine = messagingEngine;
    }

    private static enum EventType {
        DELETE_DLC_MESSAGES_EVENT;

    }
}

