/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AMQPConstructStore;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeSyncEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueSyncEvent;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class InboundDBSyncRequestEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundDBSyncRequestEvent.class);
    private static final String EVENT_TYPE = "DB_SYNC";
    private AndesContextStore andesContextStore;
    private AndesContextInformationManager contextInformationManager;
    private AndesSubscriptionManager subscriptionManager;
    private AMQPConstructStore amqpConstructStore;

    @Override
    public void updateState() throws AndesException {
        log.info((Object)"Running DB sync task.");
        this.reloadMessageRoutersFromDB();
        this.reloadQueuesFromDB();
        this.reloadBindingsFromDB();
        this.reloadSubscriptions();
    }

    @Override
    public String eventInfo() {
        return EVENT_TYPE;
    }

    public void prepareEvent(AndesContextStore contextStore, AMQPConstructStore amqpConstructStore, AndesContextInformationManager contextInformationManager, AndesSubscriptionManager subscriptionManager) {
        this.andesContextStore = contextStore;
        this.contextInformationManager = contextInformationManager;
        this.subscriptionManager = subscriptionManager;
        this.amqpConstructStore = amqpConstructStore;
    }

    private void reloadMessageRoutersFromDB() throws AndesException {
        List<AndesMessageRouter> messageRoutersStored = this.andesContextStore.getAllMessageRoutersStored();
        List<AndesMessageRouter> messageRoutersInMemory = AndesContext.getInstance().getMessageRouterRegistry().getAllMessageRouters();
        ArrayList<AndesMessageRouter> copyOfMessageRoutersStored = new ArrayList<AndesMessageRouter>(messageRoutersStored);
        messageRoutersStored.removeAll(messageRoutersInMemory);
        for (AndesMessageRouter messageRouter : messageRoutersStored) {
            log.warn((Object)("Recovering node. Adding exchange " + messageRouter.toString()));
            InboundExchangeSyncEvent exchangeCreateEvent = new InboundExchangeSyncEvent(messageRouter.encodeAsString());
            exchangeCreateEvent.prepareForCreateExchangeSync(this.contextInformationManager);
            exchangeCreateEvent.updateState();
        }
        messageRoutersInMemory.removeAll(copyOfMessageRoutersStored);
        for (AndesMessageRouter messageRouter : messageRoutersInMemory) {
            log.warn((Object)("Recovering node. Removing exchange " + messageRouter.toString()));
            InboundExchangeSyncEvent exchangeDeleteEvent = new InboundExchangeSyncEvent(messageRouter.encodeAsString());
            exchangeDeleteEvent.prepareForDeleteExchangeSync(this.contextInformationManager);
            exchangeDeleteEvent.updateState();
        }
    }

    private void reloadQueuesFromDB() throws AndesException {
        List<StorageQueue> queuesStored = this.andesContextStore.getAllQueuesStored();
        List<StorageQueue> queuesInMemory = AndesContext.getInstance().getStorageQueueRegistry().getAllStorageQueues();
        ArrayList<StorageQueue> copyOfQueuesStored = new ArrayList<StorageQueue>(queuesStored);
        queuesStored.removeAll(queuesInMemory);
        for (StorageQueue queue : queuesStored) {
            log.warn((Object)("Recovering node. Adding queue to queue registry " + queue.toString()));
            InboundQueueSyncEvent queueCreateEvent = new InboundQueueSyncEvent(queue.encodeAsString());
            queueCreateEvent.prepareForSyncCreateQueue(this.contextInformationManager);
            queueCreateEvent.updateState();
        }
        queuesInMemory.removeAll(copyOfQueuesStored);
        for (StorageQueue queue : queuesInMemory) {
            log.warn((Object)("Recovering node. Removing queue from queue registry " + queue.toString()));
            InboundQueueSyncEvent queueDeleteEvent = new InboundQueueSyncEvent(queue.encodeAsString());
            queueDeleteEvent.prepareForSyncDeleteQueue(this.contextInformationManager);
            queueDeleteEvent.updateState();
        }
    }

    private void reloadBindingsFromDB() throws AndesException {
        List<AndesMessageRouter> routersStored = this.andesContextStore.getAllMessageRoutersStored();
        for (AndesMessageRouter messageRouter : routersStored) {
            List<AndesBinding> bindingsStored = this.andesContextStore.getBindingsStoredForExchange(messageRouter.getName());
            List<AndesBinding> inMemoryBindings = this.amqpConstructStore.getBindingsForExchange(messageRouter.getName());
            ArrayList<AndesBinding> copyOfBindingsStored = new ArrayList<AndesBinding>(bindingsStored);
            bindingsStored.removeAll(inMemoryBindings);
            for (AndesBinding binding : bindingsStored) {
                log.warn((Object)("Recovering node. Adding binding " + binding.toString()));
                InboundBindingSyncEvent bindingCreateEvent = new InboundBindingSyncEvent(binding.encodeAsString());
                bindingCreateEvent.prepareForAddBindingEvent(this.contextInformationManager);
                bindingCreateEvent.updateState();
            }
            inMemoryBindings.removeAll(copyOfBindingsStored);
            for (AndesBinding binding : inMemoryBindings) {
                log.warn((Object)("Recovering node. removing binding " + binding.toString()));
                InboundBindingSyncEvent bindingDeleteEvent = new InboundBindingSyncEvent(binding.encodeAsString());
                bindingDeleteEvent.prepareForRemoveBinding(this.contextInformationManager);
                bindingDeleteEvent.updateState();
            }
        }
    }

    private void reloadSubscriptions() throws AndesException {
        this.subscriptionManager.reloadSubscriptionsFromStorage();
    }
}

