/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;

public class InboundChannelFlowEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundChannelFlowEvent.class);
    private EventType eventType = EventType.CHANNEL_FLOW_EVENT;
    private UUID channelID;
    private DisruptorEventCallback callback;
    private boolean active;

    public InboundChannelFlowEvent(UUID channelID, boolean active, DisruptorEventCallback eventCallback) {
        this.channelID = channelID;
        this.active = active;
        this.callback = eventCallback;
    }

    @Override
    public void updateState() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inbound channel flow event received. Flow status: " + this.active));
        }
        AndesContext.getInstance().getAndesSubscriptionManager().notifySubscriptionFlow(this.channelID, this.active);
        this.callback.execute();
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public static enum EventType {
        CHANNEL_FLOW_EVENT;

    }
}

