/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;

public class InboundBindingSyncEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundBindingEvent.class);
    private AndesContextInformationManager contextInformationManager;
    private EventType eventType;
    private String encodedBindingInfo;

    public InboundBindingSyncEvent(String encodedBindingInfo) {
        this.encodedBindingInfo = encodedBindingInfo;
    }

    public String getEncodedBindingInfo() {
        return this.encodedBindingInfo;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case SYNC_BINDING_ADD_EVENT: {
                this.contextInformationManager.syncCreateBinding(this);
                break;
            }
            case SYNC_BINDING_REMOVE_EVENT: {
                this.contextInformationManager.syncRemoveBinding(this);
                break;
            }
            default: {
                log.error((Object)("Event type not set properly." + (Object)((Object)this.eventType)));
            }
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForAddBindingEvent(AndesContextInformationManager contextInformationManager) {
        this.contextInformationManager = contextInformationManager;
        this.eventType = EventType.SYNC_BINDING_ADD_EVENT;
    }

    public void prepareForRemoveBinding(AndesContextInformationManager contextInformationManager) {
        this.contextInformationManager = contextInformationManager;
        this.eventType = EventType.SYNC_BINDING_REMOVE_EVENT;
    }

    private static enum EventType {
        SYNC_BINDING_ADD_EVENT,
        SYNC_BINDING_REMOVE_EVENT;

    }
}

