/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContextInformationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.inbound.AndesInboundStateEvent;
import org.wso2.andes.kernel.disruptor.inbound.QueueInfo;

public class InboundBindingEvent
implements AndesInboundStateEvent {
    private static Log log = LogFactory.getLog(InboundBindingEvent.class);
    private SettableFuture<Boolean> isEventComplete;
    private AndesContextInformationManager contextInformationManager;
    private EventType eventType;
    private String boundMessageRouterName;
    private QueueInfo boundedQueue;
    private String routingKey;

    public InboundBindingEvent(QueueInfo boundedQueue, String boundMessageRouterName, String routingKey) {
        this.boundMessageRouterName = boundMessageRouterName;
        this.boundedQueue = boundedQueue;
        this.routingKey = routingKey;
        this.isEventComplete = SettableFuture.create();
    }

    public String getBoundMessageRouterName() {
        return this.boundMessageRouterName;
    }

    public QueueInfo getBoundedQueue() {
        return this.boundedQueue;
    }

    public String getBindingKey() {
        return this.routingKey;
    }

    @Override
    public void updateState() throws AndesException {
        switch (this.eventType) {
            case ADD_BINDING_EVENT: {
                this.handleCreateBinding();
                break;
            }
            case REMOVE_BINDING_EVENT: {
                this.handleRemoveBinding();
                break;
            }
            default: {
                log.error((Object)("Event type not set properly." + (Object)((Object)this.eventType)));
            }
        }
    }

    private void handleCreateBinding() {
        boolean isComplete = false;
        try {
            this.contextInformationManager.createBinding(this);
            isComplete = true;
        }
        catch (AndesException e) {
            this.isEventComplete.setException((Throwable)e);
        }
        finally {
            this.isEventComplete.set((Object)isComplete);
        }
    }

    private void handleRemoveBinding() {
        boolean isComplete = false;
        try {
            this.contextInformationManager.removeBinding(this);
            isComplete = true;
        }
        catch (AndesException e) {
            this.isEventComplete.setException((Throwable)e);
        }
        finally {
            this.isEventComplete.set((Object)isComplete);
        }
    }

    @Override
    public String eventInfo() {
        return this.eventType.toString();
    }

    public void prepareForAddBindingEvent(AndesContextInformationManager contextInformationManager) {
        this.contextInformationManager = contextInformationManager;
        this.eventType = EventType.ADD_BINDING_EVENT;
    }

    public void prepareForRemoveBinding(AndesContextInformationManager contextInformationManager) {
        this.contextInformationManager = contextInformationManager;
        this.eventType = EventType.REMOVE_BINDING_EVENT;
    }

    public boolean waitForCompletion() throws AndesException {
        try {
            return (Boolean)this.isEventComplete.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AndesException("Error while processing inbound binding event for queue " + this.boundedQueue.getQueueName(), e);
        }
        return false;
    }

    private static enum EventType {
        ADD_BINDING_EVENT,
        REMOVE_BINDING_EVENT;

    }
}

