/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.disruptor.InboundEventHandler;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.disruptor.inbound.StateEventHandler;

public class DtxDbWriter
extends InboundEventHandler {
    private static Log log = LogFactory.getLog(StateEventHandler.class);
    private final MessagingEngine messagingEngine;
    private final int handlerCount;
    private final int turn;

    DtxDbWriter(MessagingEngine engine, int turn, int handlerCount) {
        this.messagingEngine = engine;
        this.turn = turn;
        this.handlerCount = handlerCount;
    }

    public void onEvent(InboundEventContainer event, long sequence, boolean endOfBatch) throws Exception {
        long currentTurn = sequence % (long)this.handlerCount;
        if ((long)this.turn == currentTurn) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sequence [ " + sequence + " ] Event " + (Object)((Object)event.getEventType())));
            }
            if (InboundEventContainer.Type.DTX_COMMIT_EVENT == event.getEventType()) {
                event.getDtxBranch().writeToDbOnCommit();
            } else if (InboundEventContainer.Type.DTX_ONE_PHASE_COMMIT_EVENT == event.getEventType()) {
                event.getDtxBranch().writeToDbOnOnePhaseCommit();
            } else if (InboundEventContainer.Type.DTX_ROLLBACK_EVENT == event.getEventType()) {
                event.getDtxBranch().writeToDbOnRollback();
            } else if (InboundEventContainer.Type.DTX_PREPARE_EVENT == event.getEventType()) {
                event.getDtxBranch().persistRecords();
            }
        }
    }
}

