/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.disruptor.inbound.ContentCompressionStrategy;
import org.wso2.andes.kernel.disruptor.inbound.ContentPartHolder;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;

public class ContentChunkHandler
implements EventHandler<InboundEventContainer> {
    private static Log log = LogFactory.getLog(ContentChunkHandler.class);
    private final int maxChunkSize;
    private ContentCompressionStrategy chunkStrategy;

    ContentChunkHandler(int maxChunkSize, ContentCompressionStrategy chunkStrategy) {
        this.maxChunkSize = maxChunkSize;
        this.chunkStrategy = chunkStrategy;
    }

    public void onEvent(InboundEventContainer event, long sequence, boolean endOfBatch) throws Exception {
        if (!event.availableForContentProcessing()) {
            return;
        }
        switch (event.getEventType()) {
            case MESSAGE_EVENT: {
                AndesMessage message = this.resizeContentChunks(event.popMessage(), sequence);
                event.addMessage(message);
                break;
            }
            case TRANSACTION_ENQUEUE_EVENT: {
                this.handleTransaction(event, sequence);
                break;
            }
            case DTX_ONE_PHASE_COMMIT_EVENT: 
            case DTX_COMMIT_EVENT: {
                this.handleDtxEvent(event, sequence);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Message chunk ignored for event type " + (Object)((Object)event.getEventType())));
            }
        }
    }

    private void handleDtxEvent(InboundEventContainer event, long sequence) {
        ArrayList<AndesMessage> enqueueList = event.getDtxBranch().getEnqueueList();
        for (AndesMessage andesMessage : enqueueList) {
            this.resizeContentChunks(andesMessage, sequence);
        }
    }

    private void handleTransaction(InboundEventContainer event, long sequence) {
        AndesMessage message = this.resizeContentChunks(event.popMessage(), sequence);
        event.getTransactionEvent().enqueueMessage(message);
    }

    private AndesMessage resizeContentChunks(AndesMessage message, long sequence) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ " + sequence + " ] Content chunk resize for " + message.getContentChunkList().size() + " message "));
        }
        ContentPartHolder contentChunkPair = this.chunkStrategy.ContentChunkStrategy(message);
        message.setChunkList(this.resizeChunks(contentChunkPair.getAndesMessagePartList(), contentChunkPair.getContentLength()));
        return message;
    }

    List<AndesMessagePart> resizeChunks(List<AndesMessagePart> partList, int contentLength) {
        ArrayList<AndesMessagePart> chunkList = new ArrayList<AndesMessagePart>();
        int written = 0;
        int totalRemainingLength = contentLength;
        byte[] data = null;
        int startPos = 0;
        for (AndesMessagePart chunk : partList) {
            int chunkRemainingLength;
            if (data == null && (chunk.getDataLength() == this.maxChunkSize || chunk.getDataLength() < this.maxChunkSize && chunk.getDataLength() == totalRemainingLength)) {
                chunk.setOffSet(written);
                chunkList.add(chunk);
                totalRemainingLength = contentLength - (written += chunk.getDataLength());
                continue;
            }
            int chunkStartPos = 0;
            for (chunkRemainingLength = chunk.getDataLength(); chunkRemainingLength >= this.maxChunkSize; chunkRemainingLength -= this.maxChunkSize - startPos) {
                if (null == data) {
                    data = new byte[this.maxChunkSize];
                    startPos = 0;
                }
                System.arraycopy(chunk.getData(), chunkStartPos, data, startPos, this.maxChunkSize - startPos);
                AndesMessagePart newChunk = new AndesMessagePart();
                newChunk.setMessageID(chunk.getMessageID());
                newChunk.setOffSet(written);
                newChunk.setData(data);
                chunkList.add(newChunk);
                data = null;
                chunkStartPos += this.maxChunkSize - startPos;
                startPos = 0;
                totalRemainingLength = contentLength - (written += data.length);
            }
            while (chunkRemainingLength > 0) {
                if (null == data) {
                    int arrayLength = chunkRemainingLength == totalRemainingLength ? chunkRemainingLength : (totalRemainingLength >= this.maxChunkSize ? this.maxChunkSize : totalRemainingLength);
                    data = new byte[arrayLength];
                }
                int writeSize = chunkRemainingLength <= data.length - startPos ? chunkRemainingLength : data.length - startPos;
                System.arraycopy(chunk.getData(), chunkStartPos, data, startPos, writeSize);
                chunkStartPos += writeSize;
                chunkRemainingLength -= writeSize;
                if ((startPos += writeSize) != data.length) continue;
                AndesMessagePart newChunk = new AndesMessagePart();
                newChunk.setMessageID(chunk.getMessageID());
                newChunk.setOffSet(written);
                newChunk.setData(data);
                chunkList.add(newChunk);
                totalRemainingLength = contentLength - (written += data.length);
                data = null;
                startPos = 0;
            }
        }
        return chunkList;
    }
}

