/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesAckEvent;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.store.AndesTransactionRollbackException;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class AckHandler
implements StoreHealthListener {
    private static Log log = LogFactory.getLog(AckHandler.class);
    private final MessagingEngine messagingEngine;
    private final AndesSubscriptionManager subscriptionManager;
    private static final int MAX_MESSAGE_DELETION_COUNT = 5;
    private volatile boolean messageStoresUnavailable;
    private final List<DeliverableAndesMetadata> messagesToRemove;

    AckHandler(MessagingEngine messagingEngine) {
        this.messagingEngine = messagingEngine;
        this.subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
        this.messageStoresUnavailable = false;
        this.messagesToRemove = new ArrayList<DeliverableAndesMetadata>();
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    public void processAcknowledgements(List<AndesAckEvent> ackDataList) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)(ackDataList.size() + " acknowledgements received from disruptor."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(ackDataList.size() + " acknowledgements received from disruptor."));
        }
        try {
            this.ackReceived(ackDataList);
        }
        catch (AndesException e) {
            log.error((Object)"Error occurred while processing acknowledgements ", (Throwable)e);
        }
    }

    private void ackReceived(List<AndesAckEvent> ackEventList) throws AndesException {
        for (AndesAckEvent ack : ackEventList) {
            ack.setMetadataReference();
            boolean messageRemovable = ack.processEvent();
            if (!messageRemovable) continue;
            this.messagesToRemove.add(ack.getMetadataReference());
        }
        if (!this.messageStoresUnavailable) {
            this.deleteMessagesFromStore(0);
        }
    }

    private void deleteMessagesFromStore(int numberOfRetriesBefore) throws AndesException {
        try {
            this.messagingEngine.deleteMessages(this.messagesToRemove);
            if (log.isTraceEnabled()) {
                StringBuilder messageIDsString = new StringBuilder();
                for (DeliverableAndesMetadata metadata : this.messagesToRemove) {
                    messageIDsString.append(metadata.getMessageID()).append(" , ");
                }
                log.trace((Object)(this.messagesToRemove.size() + " message ok to remove : " + messageIDsString));
            }
            this.messagesToRemove.clear();
        }
        catch (AndesTransactionRollbackException txRollback) {
            if (numberOfRetriesBefore <= 5) {
                log.warn((Object)("unable to delete messages (" + this.messagesToRemove.size() + "), due to transaction roll back. Operation will be attempted again"), (Throwable)txRollback);
                this.deleteMessagesFromStore(numberOfRetriesBefore + 1);
            }
            throw new AndesException("Unable to delete acked messages, in final attempt " + numberOfRetriesBefore + ". This might lead to message duplication.");
        }
        catch (AndesException ex) {
            log.warn((Object)String.format("unable to delete messages, probably due to errors in message stores.messages count : %d, operation will be attempted again", this.messagesToRemove.size()));
            throw ex;
        }
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.info((Object)String.format("Message store became not operational. messages to delete : %d", this.messagesToRemove.size()));
        this.messageStoresUnavailable = true;
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)String.format("Message store became operational. messages to delete : %d", this.messagesToRemove.size()));
        this.messageStoresUnavailable = false;
    }
}

