/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.inbound;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesAckEvent;
import org.wso2.andes.kernel.disruptor.InboundEventHandler;
import org.wso2.andes.kernel.disruptor.inbound.AckHandler;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;

public class AckEventBatchHandler
extends InboundEventHandler {
    private static Log log = LogFactory.getLog(AckHandler.class);
    private final List<AndesAckEvent> ackDataList;
    private final int turn;
    private final int groupCount;
    private final int batchSize;
    private final AckHandler ackHandler;

    public AckEventBatchHandler(int turn, int groupCount, int batchSize, AckHandler ackHandler) {
        this.ackDataList = new ArrayList<AndesAckEvent>(batchSize);
        this.turn = turn;
        this.groupCount = groupCount;
        this.batchSize = batchSize;
        this.ackHandler = ackHandler;
    }

    public void onEvent(InboundEventContainer event, long sequence, boolean endOfBatch) throws Exception {
        if (InboundEventContainer.Type.ACKNOWLEDGEMENT_EVENT == event.getEventType()) {
            long currentTurn = sequence % (long)this.groupCount;
            if ((long)this.turn == currentTurn) {
                this.ackDataList.add(event.ackData);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ " + sequence + " ] Current turn " + currentTurn + ", turn " + this.turn + ", groupCount " + this.groupCount + ", EventType " + (Object)((Object)InboundEventContainer.Type.ACKNOWLEDGEMENT_EVENT)));
            }
        }
        if ((this.ackDataList.size() >= this.batchSize || endOfBatch) && !this.ackDataList.isEmpty()) {
            this.ackHandler.processAcknowledgements(this.ackDataList);
            this.ackDataList.clear();
        }
    }
}

