/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.disruptor.delivery.ConcurrentContentReadTaskBatchProcessor;
import org.wso2.andes.kernel.disruptor.delivery.ContentCacheCreator;
import org.wso2.andes.kernel.disruptor.delivery.ContentDecompressionHandler;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventCleanupHandler;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventData;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventHandler;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryExceptionHandler;
import org.wso2.andes.kernel.disruptor.waitStrategy.SleepingBlockingWaitStrategy;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;

public class DisruptorBasedFlusher {
    private static Log log = LogFactory.getLog(DisruptorBasedFlusher.class);
    public static final int OUTBOUND_DISRUPTOR_SHUTDOWN_WAIT_TIME = 30;
    private final Disruptor<DeliveryEventData> disruptor;
    private final RingBuffer<DeliveryEventData> ringBuffer;

    public DisruptorBasedFlusher() {
        Integer ringBufferSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_RING_BUFFER_SIZE);
        Integer parallelContentReaders = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_PARALLEL_CONTENT_READERS);
        Integer parallelDecompressionHandlers = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_PARALLEL_DECOMPRESSION_HANDLERS);
        Integer parallelDeliveryHandlers = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_PARALLEL_DELIVERY_HANDLERS);
        Integer contentSizeToBatch = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_CONTENT_READ_BATCH_SIZE);
        int maxContentChunkSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_CONTENT_CHUNK_SIZE);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("DisruptorBasedFlusher-%d").build();
        ExecutorService threadPoolExecutor = Executors.newCachedThreadPool(namedThreadFactory);
        this.disruptor = new Disruptor((EventFactory)new DeliveryEventData.DeliveryEventDataFactory(), ringBufferSize.intValue(), (Executor)threadPoolExecutor, ProducerType.MULTI, (WaitStrategy)new SleepingBlockingWaitStrategy());
        this.disruptor.handleExceptionsWith((ExceptionHandler)new DeliveryExceptionHandler());
        SequenceBarrier barrier = this.disruptor.getRingBuffer().newBarrier(new Sequence[0]);
        EventProcessor[] contentReadTaskBatchProcessor = new ConcurrentContentReadTaskBatchProcessor[parallelContentReaders.intValue()];
        for (int i = 0; i < parallelContentReaders; ++i) {
            contentReadTaskBatchProcessor[i] = new ConcurrentContentReadTaskBatchProcessor((RingBuffer<DeliveryEventData>)this.disruptor.getRingBuffer(), barrier, new ContentCacheCreator(maxContentChunkSize), i, parallelContentReaders, contentSizeToBatch);
            contentReadTaskBatchProcessor[i].setExceptionHandler(new DeliveryExceptionHandler());
        }
        EventHandler[] decompressionEventHandlers = new ContentDecompressionHandler[parallelDecompressionHandlers.intValue()];
        for (int i = 0; i < parallelDecompressionHandlers; ++i) {
            decompressionEventHandlers[i] = new ContentDecompressionHandler(maxContentChunkSize);
        }
        EventHandler[] deliveryEventHandlers = new DeliveryEventHandler[parallelDeliveryHandlers.intValue()];
        for (int i = 0; i < parallelDeliveryHandlers; ++i) {
            deliveryEventHandlers[i] = new DeliveryEventHandler(i, parallelDeliveryHandlers.intValue());
        }
        DeliveryEventCleanupHandler deliveryEventCleanupHandler = new DeliveryEventCleanupHandler();
        this.disruptor.handleEventsWith(contentReadTaskBatchProcessor).then(decompressionEventHandlers).then(deliveryEventHandlers).then(new EventHandler[]{deliveryEventCleanupHandler});
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
        MetricManager.gauge((String)"org.wso2.mb.outbound.disruptor.message.count", (Level)Level.INFO, (Gauge)new OutBoundRingGauge());
    }

    public void submit(AndesSubscription subscription, ProtocolMessage metadata) {
        MessageTracer.trace(metadata.getMessage(), "submitted to outbound disruptor");
        long nextSequence = this.ringBuffer.next();
        DeliveryEventData data = (DeliveryEventData)this.ringBuffer.get(nextSequence);
        data.setLocalSubscription(subscription);
        data.setMetadata(metadata);
        this.ringBuffer.publish(nextSequence);
    }

    public void stop() {
        try {
            this.disruptor.shutdown(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error((Object)"Outbound disruptor did not shut down properly.");
        }
    }

    private class OutBoundRingGauge
    implements Gauge<Long> {
        private OutBoundRingGauge() {
        }

        public Long getValue() {
            return (long)DisruptorBasedFlusher.this.ringBuffer.getBufferSize() - DisruptorBasedFlusher.this.ringBuffer.remainingCapacity();
        }
    }
}

