/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageStatus;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolDeliveryFailureException;
import org.wso2.andes.kernel.ProtocolDeliveryRulesFailureException;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.SubscriptionAlreadyClosedException;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventData;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;

public class DeliveryEventHandler
implements EventHandler<DeliveryEventData> {
    private static final Logger log = Logger.getLogger(DeliveryEventHandler.class);
    private final long ordinal;
    private final long numberOfConsumers;

    public DeliveryEventHandler(long ordinal, long numberOfHandlers) {
        this.ordinal = ordinal;
        this.numberOfConsumers = numberOfHandlers;
    }

    public void onEvent(DeliveryEventData deliveryEventData, long sequence, boolean endOfBatch) throws Exception {
        AndesSubscription subscription = deliveryEventData.getLocalSubscription();
        UUID protocolChannelID = subscription.getSubscriberConnection().getProtocolChannelID();
        long channelModulus = Math.abs((long)protocolChannelID.hashCode() % this.numberOfConsumers);
        if (channelModulus == this.ordinal) {
            ProtocolMessage protocolMessage = deliveryEventData.getMetadata();
            DeliverableAndesMetadata message = protocolMessage.getMessage();
            try {
                if (deliveryEventData.isErrorOccurred()) {
                    this.onSendError(message, subscription);
                    subscription.getSubscriberConnection().onWriteToConnectionError(message.getMessageID());
                    this.routeMessageToDLC(message, subscription);
                    return;
                }
                if (!message.isStale()) {
                    if (subscription.isActive()) {
                        MessageTracer.trace(message, "dispatched to protocol level for delivery");
                        Meter messageMeter = MetricManager.meter((String)"org.wso2.mb.message.sent", (Level[])new Level[]{Level.INFO});
                        messageMeter.mark();
                        Counter counter = MetricManager.counter((String)"org.wso2.mb.dequeue.count", (Level[])new Level[]{Level.INFO});
                        counter.inc();
                        subscription.getSubscriberConnection().writeMessageToConnection(protocolMessage, deliveryEventData.getAndesContent());
                    } else {
                        this.onSendError(message, subscription);
                        this.onSubscriptionAlreadyClosed(message, subscription);
                    }
                } else {
                    this.onSendError(message, subscription);
                    this.onSubscriptionAlreadyClosed(message, subscription);
                    MessageTracer.trace(message.getMessageID(), message.getDestination(), "discarding delivery as message is stale");
                }
            }
            catch (ProtocolDeliveryRulesFailureException e) {
                this.onSendError(message, subscription);
                subscription.getSubscriberConnection().onWriteToConnectionError(message.getMessageID());
                this.routeMessageToDLC(message, subscription);
            }
            catch (SubscriptionAlreadyClosedException ex) {
                this.onSendError(message, subscription);
                this.onSubscriptionAlreadyClosed(message, subscription);
            }
            catch (ProtocolDeliveryFailureException ex) {
                this.onDeliveryException(message, subscription);
                this.reQueueMessageIfDurable(message, subscription);
            }
            catch (Throwable e) {
                log.error((Object)("Unexpected error while delivering message. Message id " + message.getMessageID()), e);
                this.onDeliveryException(message, subscription);
                this.reQueueMessageIfDurable(message, subscription);
            }
        }
    }

    private void reQueueMessageIfDurable(DeliverableAndesMetadata message, AndesSubscription subscription) throws AndesException {
        if (subscription.isDurable()) {
            StorageQueue storageQueue = subscription.getStorageQueue();
            storageQueue.bufferMessageForDelivery(message);
        } else if (!message.isOKToDispose()) {
            log.warn((Object)("Cannot send message id= " + message.getMessageID() + " as subscriber is closed"));
        }
    }

    private void onSubscriptionAlreadyClosed(DeliverableAndesMetadata message, AndesSubscription subscription) throws AndesException {
        UUID channelID = subscription.getSubscriberConnection().getProtocolChannelID();
        message.markDeliveredChannelAsClosed(channelID);
        if (!subscription.isDurable()) {
            message.evaluateMessageAcknowledgement();
            if (message.isAknowledgedByAll()) {
                ArrayList<DeliverableAndesMetadata> messageToDelete = new ArrayList<DeliverableAndesMetadata>();
                messageToDelete.add(message);
                MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)messageToDelete);
            }
        }
    }

    private void onSendError(DeliverableAndesMetadata messageMetadata, AndesSubscription localSubscription) {
        UUID channelID = localSubscription.getSubscriberConnection().getProtocolChannelID();
        messageMetadata.markDeliveryFailureOfASentMessage(channelID);
    }

    private void onDeliveryException(DeliverableAndesMetadata messageMetadata, AndesSubscription localSubscription) {
        UUID channelID = localSubscription.getSubscriberConnection().getProtocolChannelID();
        messageMetadata.markDeliveryFailureByProtocol(channelID);
        localSubscription.getSubscriberConnection().onWriteToConnectionError(messageMetadata.getMessageID());
    }

    private void routeMessageToDLC(DeliverableAndesMetadata message, AndesSubscription subscription) throws AndesException {
        if (subscription.isDurable()) {
            log.warn((Object)("Moving message to Dead Letter Channel Due to Send Error. Message ID " + message.getMessageID()));
            try {
                Andes.getInstance().moveMessageToDeadLetterChannel(message, message.getDestination());
            }
            catch (AndesException dlcException) {
                log.error((Object)("Error moving message " + message.getMessageID() + " to dead letter channel."), (Throwable)dlcException);
            }
        } else {
            log.warn((Object)("Discarding topic message id = " + message.getMessageID() + " as delivery failed"));
            message.markAsRejectedByClient(subscription.getSubscriberConnection().getProtocolChannelID());
            ArrayList<DeliverableAndesMetadata> messagesToRemove = new ArrayList<DeliverableAndesMetadata>();
            message.evaluateMessageAcknowledgement();
            if (message.getLatestState().equals((Object)MessageStatus.ACKED_BY_ALL)) {
                messagesToRemove.add(message);
            }
            MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)messagesToRemove);
        }
    }
}

