/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.lmax.disruptor.EventFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.subscription.AndesSubscription;

public class DeliveryEventData {
    private AndesSubscription localSubscription;
    private ProtocolMessage metadata;
    private boolean errorOccurred = false;
    private AndesContent andesContent;
    private final AtomicBoolean freshContent = new AtomicBoolean(true);
    private static final Logger log = Logger.getLogger(DeliveryEventData.class);

    public static EventFactory<DeliveryEventData> getFactory() {
        return new DeliveryEventDataFactory();
    }

    public void clearData() {
        this.localSubscription = null;
        this.metadata = null;
        this.errorOccurred = false;
        this.andesContent = null;
        this.freshContent.set(true);
    }

    public AndesContent getAndesContent() {
        return this.andesContent;
    }

    public void setAndesContent(AndesContent andesContent) {
        this.andesContent = andesContent;
    }

    public AndesSubscription getLocalSubscription() {
        return this.localSubscription;
    }

    public void setLocalSubscription(AndesSubscription localSubscription) {
        this.localSubscription = localSubscription;
    }

    public ProtocolMessage getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ProtocolMessage metadata) {
        this.metadata = metadata;
    }

    public void reportExceptionOccurred() {
        this.errorOccurred = true;
    }

    public String toString() {
        return "Message ID: " + this.metadata.getMessage().getMessageID() + ", Error occurred : " + this.isErrorOccurred();
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public boolean availableForDecompression() {
        return this.freshContent.compareAndSet(true, false);
    }

    public static class DeliveryEventDataFactory
    implements EventFactory<DeliveryEventData> {
        public DeliveryEventData newInstance() {
            return new DeliveryEventData();
        }
    }
}

