/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.lmax.disruptor.EventHandler;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DisruptorCachedContent;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.disruptor.compression.LZ4CompressionHelper;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventData;
import org.wso2.andes.tools.utils.MessageTracer;

public class ContentDecompressionHandler
implements EventHandler<DeliveryEventData> {
    private static final Logger log = Logger.getLogger(ContentDecompressionHandler.class);
    private final int maxChunkSize;
    private LZ4CompressionHelper lz4CompressionHelper;

    public ContentDecompressionHandler(int maxContentChunkSize) {
        this.maxChunkSize = maxContentChunkSize;
        this.lz4CompressionHelper = new LZ4CompressionHelper();
    }

    public void onEvent(DeliveryEventData deliveryEventData, long sequence, boolean endOfBatch) throws Exception {
        if (!deliveryEventData.availableForDecompression()) {
            return;
        }
        DisruptorCachedContent content = (DisruptorCachedContent)deliveryEventData.getAndesContent();
        ProtocolMessage metadata = deliveryEventData.getMetadata();
        int originalMessageSize = metadata.getMessage().getMessageContentLength();
        long messageID = metadata.getMessageID();
        boolean isCompressed = metadata.getMessage().isCompressed();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + messageID + " is compressed = " + isCompressed));
        }
        if (null != content) {
            if (isCompressed) {
                Map<Integer, AndesMessagePart> messagePartMapFromContentReader = content.getContentList();
                Collection<AndesMessagePart> contentList = messagePartMapFromContentReader.values();
                Map<Integer, AndesMessagePart> messagePartMapToDeliver = this.lz4CompressionHelper.getDecompressedMessage(contentList, originalMessageSize, messageID);
                content = new DisruptorCachedContent(messagePartMapToDeliver, originalMessageSize, this.maxChunkSize);
                MessageTracer.trace(messageID, metadata.getMessage().getDestination(), "Content decompressed");
            }
            deliveryEventData.setAndesContent(content);
        } else if (0 == originalMessageSize) {
            deliveryEventData.setAndesContent(content);
        } else {
            throw new AndesException("Empty message received while retrieving message content for message id " + messageID);
        }
    }
}

