/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.gs.collections.api.iterator.MutableLongIterator;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DisruptorCachedContent;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventData;
import org.wso2.andes.tools.utils.MessageTracer;

public class ContentCacheCreator {
    private static final Logger log = Logger.getLogger(ContentCacheCreator.class);
    private final int maxChunkSize;
    private final LongArrayList failedContentRetrivals;
    private final Cache<Long, DisruptorCachedContent> contentCache;

    public ContentCacheCreator(int maxContentChunkSize) {
        this.maxChunkSize = maxContentChunkSize;
        Integer maximumSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_CONTENT_CACHE_MAXIMUM_SIZE);
        Integer expiryTime = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_CONTENT_CACHE_EXPIRY_TIME);
        this.contentCache = CacheBuilder.newBuilder().expireAfterWrite((long)expiryTime.intValue(), TimeUnit.SECONDS).maximumSize((long)maximumSize.intValue()).concurrencyLevel(1).build();
        this.failedContentRetrivals = new LongArrayList();
    }

    public void onEvent(List<DeliveryEventData> eventDataList) throws AndesException {
        LongHashSet messagesToFetch = new LongHashSet();
        ArrayList<DeliveryEventData> messagesWithoutCachedContent = new ArrayList<DeliveryEventData>();
        for (DeliveryEventData deliveryEventData : eventDataList) {
            ProtocolMessage metadata = deliveryEventData.getMetadata();
            long messageID = metadata.getMessageID();
            int contentLength = metadata.getMessage().getMessageContentLength();
            if (contentLength <= 0) continue;
            DisruptorCachedContent content = (DisruptorCachedContent)this.contentCache.getIfPresent((Object)messageID);
            if (null != content) {
                deliveryEventData.setAndesContent(content);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Content read from cache for message " + messageID));
                continue;
            }
            messagesToFetch.add(messageID);
            messagesWithoutCachedContent.add(deliveryEventData);
        }
        LongArrayList containMessegesToFetch = new LongArrayList();
        containMessegesToFetch.addAll(messagesToFetch);
        LongObjectHashMap<List<AndesMessagePart>> contentListMap = MessagingEngine.getInstance().getContent(containMessegesToFetch);
        for (DeliveryEventData deliveryEventData : messagesWithoutCachedContent) {
            ProtocolMessage metadata = deliveryEventData.getMetadata();
            long messageID = metadata.getMessageID();
            DisruptorCachedContent content = (DisruptorCachedContent)this.contentCache.getIfPresent((Object)messageID);
            if (null != content) {
                deliveryEventData.setAndesContent(content);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Content read from cache for message " + messageID));
                continue;
            }
            int contentSize = metadata.getMessage().getMessageContentLength();
            List<AndesMessagePart> contentList = contentListMap.get(messageID);
            if (null != contentList) {
                HashMap<Integer, AndesMessagePart> messagePartMap = new HashMap<Integer, AndesMessagePart>(contentList.size());
                for (AndesMessagePart messagePart : contentList) {
                    messagePartMap.put(messagePart.getOffset(), messagePart);
                }
                content = new DisruptorCachedContent(messagePartMap, contentSize, this.maxChunkSize);
                this.contentCache.put((Object)messageID, (Object)content);
                deliveryEventData.setAndesContent(content);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("All content read for message " + messageID));
                }
            } else {
                this.recordFailedMessageContentRetrievalError(deliveryEventData);
            }
            MessageTracer.trace(metadata.getMessage(), "content read from database");
            this.logFailedMessageContentRetreivalErrors();
        }
    }

    private void recordFailedMessageContentRetrievalError(DeliveryEventData deliveryEventData) {
        deliveryEventData.reportExceptionOccurred();
        this.failedContentRetrivals.add(deliveryEventData.getMetadata().getMessageID());
    }

    private void logFailedMessageContentRetreivalErrors() {
        if (!this.failedContentRetrivals.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder("message content not found for message ids : ");
            MutableLongIterator iterator = this.failedContentRetrivals.longIterator();
            while (iterator.hasNext()) {
                long messageId = iterator.next();
                errorMsg.append(messageId).append(',');
            }
            this.failedContentRetrivals.clear();
            log.error((Object)errorMsg.toString());
        }
    }
}

