/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.delivery;

import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SequenceReportingEventHandler;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.ProtocolMessage;
import org.wso2.andes.kernel.disruptor.delivery.ContentCacheCreator;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryEventData;
import org.wso2.andes.kernel.disruptor.delivery.DeliveryExceptionHandler;

public class ConcurrentContentReadTaskBatchProcessor
implements EventProcessor {
    private static Log log = LogFactory.getLog(ConcurrentContentReadTaskBatchProcessor.class);
    private final AtomicBoolean running;
    private ExceptionHandler exceptionHandler;
    private final RingBuffer<DeliveryEventData> ringBuffer;
    private final SequenceBarrier sequenceBarrier;
    private final ContentCacheCreator eventHandler;
    private final Sequence sequence = new Sequence(-1L);
    private final long turn;
    private final int groupCount;
    private int batchSize;

    public ConcurrentContentReadTaskBatchProcessor(RingBuffer<DeliveryEventData> ringBuffer, SequenceBarrier sequenceBarrier, ContentCacheCreator eventHandler, long turn, int groupCount, int batchSize) {
        if (turn >= (long)groupCount) {
            throw new IllegalArgumentException("Turn should be less than groupCount");
        }
        this.ringBuffer = ringBuffer;
        this.sequenceBarrier = sequenceBarrier;
        this.eventHandler = eventHandler;
        this.turn = turn;
        this.groupCount = groupCount;
        this.batchSize = batchSize;
        this.exceptionHandler = new DeliveryExceptionHandler();
        this.running = new AtomicBoolean(false);
        if (eventHandler instanceof SequenceReportingEventHandler) {
            ((SequenceReportingEventHandler)eventHandler).setSequenceCallback(this.sequence);
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void halt() {
        this.running.set(false);
        this.sequenceBarrier.alert();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (null == exceptionHandler) {
            throw new NullPointerException("Exception handler cannot be null.");
        }
        this.exceptionHandler = exceptionHandler;
    }

    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Thread is already running");
        }
        this.sequenceBarrier.clearAlert();
        this.notifyStart();
        DeliveryEventData event = null;
        int totalContentLength = 0;
        ArrayList<DeliveryEventData> eventList = new ArrayList<DeliveryEventData>(this.batchSize);
        LongHashSet messageIDSet = new LongHashSet();
        long nextSequence = this.sequence.get() + 1L;
        while (true) {
            try {
                while (true) {
                    long availableSequence = this.sequenceBarrier.waitFor(nextSequence);
                    while (nextSequence <= availableSequence) {
                        event = (DeliveryEventData)this.ringBuffer.get(nextSequence);
                        ProtocolMessage metadata = event.getMetadata();
                        long currentMessageID = metadata.getMessageID();
                        long currentTurn = currentMessageID % (long)this.groupCount;
                        if (this.turn == currentTurn) {
                            eventList.add(event);
                            totalContentLength += metadata.getMessage().getMessageContentLength();
                            messageIDSet.add(currentMessageID);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[ " + nextSequence + " ] Current turn " + currentTurn + ", turn " + this.turn + ", groupCount " + this.groupCount));
                        }
                        if (!(totalContentLength < this.batchSize && nextSequence != availableSequence || eventList.isEmpty())) {
                            this.eventHandler.onEvent(eventList);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Event handler called with message id list " + messageIDSet));
                            }
                            eventList.clear();
                            messageIDSet.clear();
                            totalContentLength = 0;
                        }
                        ++nextSequence;
                    }
                    this.sequence.set(nextSequence - 1L);
                }
            }
            catch (AlertException ex) {
                if (this.running.get()) continue;
            }
            catch (Throwable ex) {
                log.error((Object)"Exception occurred while processing batched content reads. ", ex);
                this.exceptionHandler.handleEventException(ex, nextSequence, event);
                this.sequence.set(nextSequence);
                eventList.clear();
                messageIDSet.clear();
                totalContentLength = 0;
                ++nextSequence;
                continue;
            }
            break;
        }
        this.notifyShutdown();
        this.running.set(false);
    }

    private void notifyStart() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)this.eventHandler).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.eventHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)this.eventHandler).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

