/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor.compression;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesMessagePart;

public class LZ4CompressionHelper {
    static final boolean isCompressionEnabled = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_ALLOW_COMPRESSION);
    static final int contentCompressionThreshold = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_CONTENT_COMPRESSION_THRESHOLD);
    static final int maxChunkSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_CONTENT_CHUNK_SIZE);
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private static final LZ4Compressor compressor = factory.fastCompressor();
    private static final LZ4FastDecompressor decompressor = factory.fastDecompressor();

    public AndesMessagePart getCompressedMessage(List<AndesMessagePart> partList, int originalContentLength) {
        byte[] messageData = this.getByteArrayFromPartListForCompression(partList, originalContentLength);
        int maxCompressedLength = compressor.maxCompressedLength(originalContentLength);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(messageData, 0, originalContentLength, compressed, 0, maxCompressedLength);
        byte[] compressedMessage = Arrays.copyOf(compressed, compressedLength);
        return this.getAndesMessagePart(compressedMessage, partList.get(0).getMessageID());
    }

    public Map<Integer, AndesMessagePart> getDecompressedMessage(Collection<AndesMessagePart> messagePartList, int originalContentLength, long messageID) {
        byte[] compressedMessageContent = this.getByteArrayFromPartListForDecompression(messagePartList);
        byte[] decompressedMessage = new byte[originalContentLength];
        decompressor.decompress(compressedMessageContent, 0, decompressedMessage, 0, originalContentLength);
        return this.getHashMapFromByteArray(decompressedMessage, messageID);
    }

    public AndesMessagePart getDecompressedMessage(List<AndesMessagePart> partList, int originalContentLength) {
        byte[] compressedMessageContent = this.getByteArrayFromPartListForDecompression(partList);
        byte[] decompressedMessage = new byte[originalContentLength];
        decompressor.decompress(compressedMessageContent, 0, decompressedMessage, 0, originalContentLength);
        AndesMessagePart andesMessagePart = new AndesMessagePart();
        andesMessagePart.setData(decompressedMessage);
        andesMessagePart.setOffSet(decompressedMessage.length);
        return andesMessagePart;
    }

    private byte[] getByteArrayFromPartListForCompression(Collection<AndesMessagePart> partList, int originalContentLength) {
        byte[] messageData = new byte[originalContentLength];
        for (AndesMessagePart messagePart : partList) {
            byte[] messagePartData = messagePart.getData();
            System.arraycopy(messagePartData, 0, messageData, messagePart.getOffset(), messagePartData.length);
        }
        return messageData;
    }

    private byte[] getByteArrayFromPartListForDecompression(Collection<AndesMessagePart> partList) {
        int maximumCompressedDataLength = partList.size() * maxChunkSize;
        byte[] messageData = new byte[maximumCompressedDataLength];
        int exactCompressedDataLength = 0;
        for (AndesMessagePart messagePart : partList) {
            byte[] messagePartData = messagePart.getData();
            int messagePartLength = messagePartData.length;
            System.arraycopy(messagePartData, 0, messageData, messagePart.getOffset(), messagePartLength);
            exactCompressedDataLength += messagePartLength;
        }
        System.arraycopy(messageData, 0, messageData, 0, exactCompressedDataLength);
        return messageData;
    }

    AndesMessagePart getAndesMessagePart(byte[] data, long messageID) {
        AndesMessagePart messagePart = new AndesMessagePart();
        messagePart.setMessageID(messageID);
        messagePart.setOffSet(0);
        messagePart.setData(data);
        return messagePart;
    }

    public Map<Integer, AndesMessagePart> getHashMapFromByteArray(byte[] decompressedMessage, long messageID) {
        int decompressedMessageLength = decompressedMessage.length;
        HashMap<Integer, AndesMessagePart> messagePartMapToDeliver = new HashMap<Integer, AndesMessagePart>((int)Math.ceil((float)decompressedMessageLength / (float)maxChunkSize));
        int srcOffset = 0;
        int remainingElements = decompressedMessageLength - srcOffset;
        while (remainingElements > 0) {
            int noOfElementsToCopy = Math.min(decompressedMessageLength - srcOffset, maxChunkSize);
            byte[] copy = new byte[maxChunkSize];
            System.arraycopy(decompressedMessage, srcOffset, copy, 0, noOfElementsToCopy);
            AndesMessagePart messagePart = new AndesMessagePart();
            messagePart.setMessageID(messageID);
            messagePart.setOffSet(srcOffset);
            messagePart.setData(copy);
            messagePartMapToDeliver.put(messagePart.getOffset(), messagePart);
            remainingElements = decompressedMessageLength - (srcOffset += maxChunkSize);
        }
        return messagePartMapToDeliver;
    }

    public boolean isCompressionEnabled() {
        return isCompressionEnabled;
    }

    public int getContentCompressionThreshold() {
        return contentCompressionThreshold;
    }
}

