/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor;

import com.lmax.disruptor.ExceptionHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;

public class LogExceptionHandler
implements ExceptionHandler<InboundEventContainer> {
    private static Log log = LogFactory.getLog(LogExceptionHandler.class);

    public void handleEventException(Throwable throwable, long sequence, InboundEventContainer event) {
        String eventType;
        if (event.getEventType() == InboundEventContainer.Type.IGNORE_EVENT) {
            eventType = "";
        } else {
            eventType = "Event type: " + event.getEventType().toString();
            event.setError(throwable);
        }
        log.error((Object)("[ Sequence: " + sequence + " ] Exception occurred while processing inbound events." + eventType), throwable);
    }

    public void handleOnStartException(Throwable throwable) {
        log.error((Object)"Error while starting Disruptor ", throwable);
    }

    public void handleOnShutdownException(Throwable throwable) {
        log.error((Object)"Error while shutting down Disruptor ", throwable);
    }
}

