/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel.disruptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.disruptor.InboundEventHandler;
import org.wso2.andes.kernel.disruptor.inbound.InboundEventContainer;
import org.wso2.andes.kernel.disruptor.inbound.MessageWriter;

public class ConcurrentBatchEventHandler
extends InboundEventHandler {
    private static Log log = LogFactory.getLog(ConcurrentBatchEventHandler.class);
    private final MessageWriter messageWriter;
    private final long turn;
    private final int groupCount;
    private int batchSize;
    private final InboundEventContainer.Type eventType;
    private final List<AndesMessage> messageList;
    private final Map<String, AndesMessage> retainMap;

    public ConcurrentBatchEventHandler(long turn, int groupCount, int batchSize, InboundEventContainer.Type eventType, MessageWriter messageWriter) {
        if (turn >= (long)groupCount) {
            throw new IllegalArgumentException("Turn should be less than groupCount");
        }
        this.turn = turn;
        this.groupCount = groupCount;
        this.batchSize = batchSize;
        this.eventType = eventType;
        this.messageWriter = messageWriter;
        this.messageList = new ArrayList<AndesMessage>(this.batchSize);
        this.retainMap = new HashMap<String, AndesMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(InboundEventContainer event, long sequence, boolean endOfBatch) throws Exception {
        if (this.eventType == event.getEventType()) {
            long currentTurn = sequence % (long)this.groupCount;
            if (this.turn == currentTurn) {
                this.messageList.addAll(event.getMessageList());
                if (null != event.retainMessage) {
                    this.retainMap.put(event.retainMessage.getMetadata().getDestination(), event.retainMessage);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ " + sequence + " ] Current turn " + currentTurn + ", turn " + this.turn + ", groupCount " + this.groupCount + ", EventType " + (Object)((Object)this.eventType)));
            }
        }
        if (this.messageList.size() >= this.batchSize || endOfBatch) {
            try {
                this.messageWriter.writeMessages(this.messageList, this.retainMap);
                this.messageList.clear();
                this.retainMap.clear();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event handler called with " + this.messageList.size() + " events. EventType " + (Object)((Object)this.eventType)));
                }
            }
            finally {
                this.messageList.clear();
            }
        }
    }
}

