/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.andes.kernel.AndesException;

public class TopicParserUtil {
    private static final Logger log = Logger.getLogger(TopicParserUtil.class);
    public static final String TOPIC_TOKEN_SEPARATOR = "/";
    public static final String MULTIPLE_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";

    public static boolean isMatching(String topicName, String subscriptionTopicName) throws AndesException {
        try {
            int token;
            List<Token> msgTokens = TopicParserUtil.splitTopic(topicName);
            List<Token> subscriptionTokens = TopicParserUtil.splitTopic(subscriptionTopicName);
            Token subToken = null;
            for (token = 0; token < subscriptionTokens.size(); ++token) {
                subToken = subscriptionTokens.get(token);
                if (subToken != Token.MULTI && subToken != Token.SINGLE) {
                    if (token >= msgTokens.size()) {
                        return false;
                    }
                    Token msgToken = msgTokens.get(token);
                    if (msgToken.equals(subToken)) continue;
                    return false;
                }
                if (subToken != Token.MULTI) continue;
                return true;
            }
            return token == msgTokens.size();
        }
        catch (ParseException ex) {
            log.error((Object)"Topic format is incorrect", (Throwable)ex);
            throw new AndesException(ex);
        }
    }

    private static List<Token> splitTopic(String topic) throws ParseException {
        ArrayList<Token> resultArray = new ArrayList<Token>();
        String[] tokens = topic.split(TOPIC_TOKEN_SEPARATOR);
        if (tokens.length == 0) {
            resultArray.add(Token.EMPTY);
        }
        if (topic.endsWith(TOPIC_TOKEN_SEPARATOR)) {
            String[] newSplit = new String[tokens.length + 1];
            System.arraycopy(tokens, 0, newSplit, 0, tokens.length);
            newSplit[tokens.length] = "";
            tokens = newSplit;
        }
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.isEmpty()) {
                resultArray.add(Token.EMPTY);
                continue;
            }
            if (token.equals(MULTIPLE_LEVEL_WILDCARD)) {
                if (i != tokens.length - 1) {
                    throw new ParseException("Bad format of topic, the multi symbol (#) has to be the last one after a separator", i);
                }
                resultArray.add(Token.MULTI);
                continue;
            }
            if (token.contains(MULTIPLE_LEVEL_WILDCARD)) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + token, i);
            }
            if (token.equals(SINGLE_LEVEL_WILDCARD)) {
                resultArray.add(Token.SINGLE);
                continue;
            }
            if (token.contains(SINGLE_LEVEL_WILDCARD)) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + token, i);
            }
            resultArray.add(new Token(token));
        }
        return resultArray;
    }

    private static class Token {
        static final Token EMPTY = new Token("");
        static final Token MULTI = new Token("#");
        static final Token SINGLE = new Token("+");
        String name;

        protected Token(String tokenName) {
            this.name = tokenName;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            return !(null != this.name ? !this.name.equals(other.name) : null != other.name);
        }

        public String toString() {
            return this.name;
        }

        protected String name() {
            return this.name;
        }
    }
}

