/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.nio.ByteBuffer;
import java.util.Map;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessagePart;

public class RetainedContent
implements AndesContent {
    private final int contentLength;
    private Map<Integer, AndesMessagePart> messagePartCache;
    private long messageID;

    public RetainedContent(Map<Integer, AndesMessagePart> messageParts, int contentLength, long messageID) {
        this.messagePartCache = messageParts;
        this.contentLength = contentLength;
        this.messageID = messageID;
    }

    @Override
    public int putContent(int offset, ByteBuffer destinationBuffer) throws AndesException {
        int written = 0;
        int remainingBufferSpace = destinationBuffer.remaining();
        int remainingContent = this.contentLength - offset;
        int maxRemaining = Math.min(remainingBufferSpace, remainingContent);
        int currentBytePosition = offset;
        while (maxRemaining > written) {
            int chunkNumber = currentBytePosition / AMQPUtils.DEFAULT_CONTENT_CHUNK_SIZE;
            int chunkStartByteIndex = chunkNumber * AMQPUtils.DEFAULT_CONTENT_CHUNK_SIZE;
            int positionToReadFromChunk = currentBytePosition - chunkStartByteIndex;
            int remaining = maxRemaining - written;
            AndesMessagePart messagePart = this.getMessagePart(chunkStartByteIndex);
            int messagePartSize = messagePart.getDataLength();
            int numOfBytesAvailableToRead = messagePartSize - positionToReadFromChunk;
            int numOfBytesToRead = remaining > numOfBytesAvailableToRead ? numOfBytesAvailableToRead : remaining;
            destinationBuffer.put(messagePart.getData(), positionToReadFromChunk, numOfBytesToRead);
            written += numOfBytesToRead;
            currentBytePosition += numOfBytesToRead;
        }
        return written;
    }

    private AndesMessagePart getMessagePart(int indexToQuery) throws AndesException {
        AndesMessagePart messagePart = this.messagePartCache.get(indexToQuery);
        if (null == messagePart) {
            throw new AndesException("Content not cached for chunk index " + indexToQuery + " for message ID " + this.messageID);
        }
        return messagePart;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }
}

