/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.subscription.Subscription;

public class QueueBrowserMessageFlusher {
    private Subscription subscription;
    private AMQQueue queue;
    private static Log log = LogFactory.getLog(QueueBrowserMessageFlusher.class);

    public QueueBrowserMessageFlusher(Subscription subscription, AMQQueue queue) {
        this.subscription = subscription;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndSendFromMessageStore() throws AndesException {
        long startMessageIdOfBatch = 0L;
        long lastMessageIdOfBatch = 0L;
        int messageCountToRead = 1000;
        int errorCount = 0;
        int maxErrorCount = 20;
        long messageCount = 0L;
        try {
            List<QueueEntry> messages;
            while (!(messages = this.readMessagesFromStore(startMessageIdOfBatch, messageCountToRead)).isEmpty()) {
                for (QueueEntry message : messages) {
                    try {
                        ++messageCount;
                        lastMessageIdOfBatch = message.getMessage().getMessageNumber();
                        this.subscription.send(message);
                    }
                    catch (AMQException e) {
                        log.error((Object)("Error while delivering message id = " + message.getMessage().getMessageNumber() + " to browser subscription id= " + this.subscription.getSubscriptionID()));
                        if (++errorCount <= maxErrorCount) continue;
                        break;
                    }
                }
                if (errorCount > maxErrorCount) {
                    log.error((Object)("Stopping delivery to browser subscription id = " + this.subscription.getSubscriptionID()));
                    break;
                }
                startMessageIdOfBatch = lastMessageIdOfBatch + 1L;
            }
        }
        finally {
            this.subscription.confirmAutoClose();
        }
    }

    private List<QueueEntry> readMessagesFromStore(long startMessageIdOfBatch, int messageCountToRead) throws AndesException {
        String queueName = this.queue.getResourceName();
        List<AndesMessageMetadata> currentlyReadMessageMetaData = MessagingEngine.getInstance().getNextNMessageMetadataFromQueue(queueName, startMessageIdOfBatch, messageCountToRead);
        ArrayList<QueueEntry> queueEntries = new ArrayList<QueueEntry>();
        for (AndesMessageMetadata message : currentlyReadMessageMetaData) {
            AMQMessage amqMessage = AMQPUtils.getAMQMessageFromAndesMetaData(message);
            queueEntries.add(AMQPUtils.convertAMQMessageToQueueEntry(amqMessage, this.queue));
        }
        return queueEntries;
    }
}

