/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DeliveryResponsibility;
import org.wso2.andes.kernel.subscription.AndesSubscription;

public class PurgedMessageHandler
extends DeliveryResponsibility {
    private static Log log = LogFactory.getLog(PurgedMessageHandler.class);

    @Override
    protected boolean performResponsibility(AndesSubscription subscription, DeliverableAndesMetadata message) throws AndesException {
        boolean isOkayToProceed = false;
        long lastPurgedTimestampOfQueue = subscription.getStorageQueue().getLastPurgedTimestamp();
        if (message.getArrivalTime() <= lastPurgedTimestampOfQueue) {
            log.warn((Object)("Message was sent at " + message.getArrivalTime() + " before last purge event at " + lastPurgedTimestampOfQueue + ". Therefore, it will not be sent. id= " + message.getMessageID()));
            if (!message.isPurgedOrDeletedOrExpired()) {
                message.markAsPurgedMessage();
            }
        } else {
            isOkayToProceed = true;
        }
        return isOkayToProceed;
    }
}

