/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.UUID;
import org.wso2.andes.kernel.DeliverableAndesMetadata;

public class ProtocolMessage {
    private DeliverableAndesMetadata message;
    private long messageID;
    private UUID channelID;
    private int numberOfDeliveriesForProtocolChannel;
    private boolean isRedelivered = false;

    public ProtocolMessage(DeliverableAndesMetadata message, UUID channelID) {
        this.message = message;
        this.channelID = channelID;
        this.messageID = message.getMessageID();
        this.numberOfDeliveriesForProtocolChannel = message.getNumOfDeliveries4Channel(channelID);
        if (this.numberOfDeliveriesForProtocolChannel > 1) {
            this.isRedelivered = true;
        }
    }

    public long getMessageID() {
        return this.messageID;
    }

    public boolean isRedelivered() {
        return this.isRedelivered;
    }

    public DeliverableAndesMetadata getMessage() {
        return this.message;
    }

    public int getNumberOfDeliveriesForProtocolChannel() {
        return this.numberOfDeliveriesForProtocolChannel;
    }

    public UUID getChannelID() {
        return this.channelID;
    }
}

