/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class PreDeliveryExpiryMessageDeletionTask
implements Runnable,
StoreHealthListener {
    private static Log log = LogFactory.getLog(PreDeliveryExpiryMessageDeletionTask.class);
    private BlockingDeque<DeliverableAndesMetadata> expiredMessages;
    private volatile SettableFuture<Boolean> messageStoresUnavailable = null;
    private Boolean moveExpiredToDLC = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MOVE_EXPIRED_MESSAGES_TO_DLC);

    PreDeliveryExpiryMessageDeletionTask() {
        this.expiredMessages = new LinkedBlockingDeque<DeliverableAndesMetadata>();
        FailureObservingStoreManager.registerStoreHealthListener(this);
    }

    void addMessageIdToExpiredQueue(DeliverableAndesMetadata expiredMessage) {
        this.expiredMessages.add(expiredMessage);
    }

    @Override
    public void run() {
        if (null != this.messageStoresUnavailable) {
            try {
                log.info((Object)"Message store has become unavailable therefore expiry message deletion task iswaiting until store becomes available");
                this.messageStoresUnavailable.get();
                log.info((Object)"Message store became available. Resuming expiry message deletion task");
                this.messageStoresUnavailable = null;
            }
            catch (InterruptedException e) {
                log.error((Object)"Thread interrupted while waiting for message stores to come online", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error((Object)"Error occurred while waiting for message stores to come online", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error occurred during the pre delivery expiry message deletion task", e);
            }
        }
        if (!this.expiredMessages.isEmpty()) {
            try {
                ArrayList<DeliverableAndesMetadata> expiredMessagesList = new ArrayList<DeliverableAndesMetadata>();
                this.expiredMessages.drainTo(expiredMessagesList);
                if (this.moveExpiredToDLC.booleanValue()) {
                    MessagingEngine.getInstance().moveMessageToDeadLetterChannel((List<DeliverableAndesMetadata>)expiredMessagesList);
                } else {
                    MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)expiredMessagesList);
                }
            }
            catch (AndesException e) {
                log.error((Object)"Error running message expiration checker ", (Throwable)e);
            }
        }
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.warn((Object)"Message store became not operational.");
        this.messageStoresUnavailable = SettableFuture.create();
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Message store became operational.");
        this.messageStoresUnavailable.set((Object)false);
    }
}

