/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.AbstractSlotManager;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.kernel.slot.SlotManagerStandalone;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;
import org.wso2.andes.tools.utils.MessageTracer;

public class PeriodicExpiryMessageDeletionTask
implements Runnable,
StoreHealthListener {
    private static Log log = LogFactory.getLog(PeriodicExpiryMessageDeletionTask.class);
    private static Log expiryLog = LogFactory.getLog((String)"MessageExpirationTask");
    private static final long RETRIEVE_MESSAGE_COUNT = 10000L;
    private volatile SettableFuture<Boolean> messageStoresUnavailable = null;
    private AbstractSlotManager abstractSlotManagerSlotManager;
    protected boolean isClusteringEnabled;

    PeriodicExpiryMessageDeletionTask() {
        FailureObservingStoreManager.registerStoreHealthListener(this);
        this.isClusteringEnabled = AndesContext.getInstance().isClusteringEnabled();
        this.abstractSlotManagerSlotManager = this.isClusteringEnabled ? SlotManagerClusterMode.getInstance() : SlotManagerStandalone.getInstance();
    }

    private void deleteExpiredMessages() {
        try {
            if (!this.isClusteringEnabled || AndesContext.getInstance().getClusterAgent().isCoordinator()) {
                this.deleteExpiredMessagesFromDLC();
                Set<String> queues = this.abstractSlotManagerSlotManager.getAllQueues();
                for (String queueName : queues) {
                    long currentDeletionRangeLowerBoundId = this.abstractSlotManagerSlotManager.getSafeZoneLowerBoundId(queueName);
                    if (currentDeletionRangeLowerBoundId == -1L) continue;
                    List<Long> expiredMessages = MessagingEngine.getInstance().getExpiredMessages(currentDeletionRangeLowerBoundId, queueName);
                    if (null != this.messageStoresUnavailable) {
                        log.info((Object)"Message store has become unavailable therefore expiry message deletion task waiting until store becomes available");
                        this.messageStoresUnavailable.get();
                        log.info((Object)"Message store became available. Resuming expiry message deletion task");
                        this.messageStoresUnavailable = null;
                    }
                    if (null != expiredMessages && !expiredMessages.isEmpty()) {
                        if (MessageTracer.isEnabled()) {
                            for (Long messageId : expiredMessages) {
                                MessageTracer.trace((long)messageId, "", "expired messages detected from the database");
                            }
                        }
                        MessagingEngine.getInstance().deleteMessagesById(expiredMessages);
                        if (expiryLog.isWarnEnabled()) {
                            for (Long expiredMessageId : expiredMessages) {
                                expiryLog.warn((Object)("Message is expired. Therefore, it will be deleted. : id= " + expiredMessageId));
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Expired message count for queue : " + queueName + "is" + expiredMessages.size()));
                        }
                    }
                    this.abstractSlotManagerSlotManager.clearDeletionTaskState();
                }
            }
        }
        catch (AndesException e) {
            log.error((Object)("Error running Message Expiration Checker " + e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Thread interrupted while waiting for message stores to come online", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Error occurred while waiting for message stores to come online", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred during the periodic expiry message deletion task", e);
        }
    }

    private void deleteExpiredMessagesFromDLC() throws InterruptedException, ExecutionException, AndesException {
        if (null != this.messageStoresUnavailable) {
            log.info((Object)"Message store has become unavailable therefore expiry message deletion task waiting until store becomes available");
            this.messageStoresUnavailable.get();
            log.info((Object)"Message store became available. Resuming expiry message deletion task");
            this.messageStoresUnavailable = null;
        }
        List<Long> expiredMessages = MessagingEngine.getInstance().getExpiredMessagesFromDLC(10000L);
        while (!expiredMessages.isEmpty()) {
            if (MessageTracer.isEnabled()) {
                for (Long messageId : expiredMessages) {
                    MessageTracer.trace((long)messageId, "", "expired message detected fromthe DLC");
                }
            }
            MessagingEngine.getInstance().deleteMessagesById(expiredMessages);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expired message count in DLC is :" + expiredMessages.size()));
            }
            expiredMessages = MessagingEngine.getInstance().getExpiredMessagesFromDLC(10000L);
        }
    }

    @Override
    public void run() {
        this.deleteExpiredMessages();
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.warn((Object)"Message store became not operational.");
        this.messageStoresUnavailable = SettableFuture.create();
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Message store became operational.");
        this.messageStoresUnavailable.set((Object)false);
    }
}

