/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageDeliveryStrategy;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class NoLossBurstTopicMessageDeliveryImpl
implements MessageDeliveryStrategy {
    private static Log log = LogFactory.getLog(NoLossBurstTopicMessageDeliveryImpl.class);

    @Override
    public int deliverMessageToSubscriptions(StorageQueue storageQueue) throws AndesException {
        Collection<DeliverableAndesMetadata> messages = storageQueue.getMessagesForDelivery();
        int sentMessageCount = 0;
        Iterator<DeliverableAndesMetadata> iterator = messages.iterator();
        ArrayList<DeliverableAndesMetadata> droppedTopicMessagesList = new ArrayList<DeliverableAndesMetadata>();
        List<AndesSubscription> subscriptions4Queue = storageQueue.getBoundSubscriptions();
        List<AndesSubscription> currentSubscriptions = Collections.unmodifiableList(subscriptions4Queue);
        while (iterator.hasNext()) {
            try {
                DeliverableAndesMetadata message = iterator.next();
                ArrayList<AndesSubscription> subscriptionsToDeliver = new ArrayList<AndesSubscription>();
                for (AndesSubscription subscription : currentSubscriptions) {
                    if (subscription.getSubscriberConnection().isSuspended() || subscription.getSubscriberConnection().getSubscribeTime() > message.getArrivalTime() || !subscription.getSubscriberConnection().isMessageAcceptedByConnectionSelector(message)) continue;
                    subscriptionsToDeliver.add(subscription);
                }
                if (subscriptionsToDeliver.size() == 0) {
                    iterator.remove();
                    droppedTopicMessagesList.add(message);
                    continue;
                }
                boolean allTopicSubscriptionsSaturated = true;
                for (AndesSubscription subscription : subscriptionsToDeliver) {
                    if (!(subscription.getSubscriberConnection().hasRoomToAcceptMessages() & subscription.getSubscriberConnection().isReadyToDeliver())) continue;
                    allTopicSubscriptionsSaturated = false;
                    break;
                }
                if (allTopicSubscriptionsSaturated) break;
                message.markAsScheduledToDeliver(subscriptionsToDeliver);
                iterator.remove();
                for (AndesSubscription localSubscription : subscriptionsToDeliver) {
                    MessageFlusher.getInstance().deliverMessageAsynchronously(localSubscription, message);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing Scheduled to send message from buffer. MsgId= " + message.getMessageID()));
                }
                ++sentMessageCount;
            }
            catch (NoSuchElementException ex) {
                log.warn((Object)"NoSuchElementException thrown. ", (Throwable)ex);
                break;
            }
        }
        MessagingEngine.getInstance().deleteMessages((List<DeliverableAndesMetadata>)droppedTopicMessagesList);
        return sentMessageCount;
    }
}

