/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesAckEvent;
import org.wso2.andes.kernel.AndesContent;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageExpiryManager;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.RetainedContent;
import org.wso2.andes.kernel.TopicParserUtil;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.slot.SlotCoordinator;
import org.wso2.andes.kernel.slot.SlotCoordinatorCluster;
import org.wso2.andes.kernel.slot.SlotCoordinatorStandalone;
import org.wso2.andes.kernel.slot.SlotDeliveryWorkerManager;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.kernel.slot.SlotManagerStandalone;
import org.wso2.andes.kernel.slot.SlotMessageCounter;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.MessageIdGenerator;
import org.wso2.andes.server.cluster.coordination.TimeStampBasedMessageIdGenerator;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.tools.utils.MessageTracer;

public class MessagingEngine {
    private static final Logger log = Logger.getLogger(MessagingEngine.class);
    private static MessagingEngine messagingEngine = new MessagingEngine();
    private MessageIdGenerator messageIdGenerator;
    private MessageStore messageStore;
    private SlotCoordinator slotCoordinator;
    private MessageExpiryManager messageExpiryManager;
    private AndesSubscriptionManager subscriptionManager;

    private MessagingEngine() {
    }

    public static MessagingEngine getInstance() {
        return messagingEngine;
    }

    public void initialise(MessageStore messageStore, MessageExpiryManager messageExpiryManager, AndesSubscriptionManager subscriptionManager) throws AndesException {
        this.configureMessageIDGenerator();
        this.messageStore = messageStore;
        this.messageExpiryManager = messageExpiryManager;
        this.subscriptionManager = subscriptionManager;
        this.slotCoordinator = AndesContext.getInstance().isClusteringEnabled() ? new SlotCoordinatorCluster() : new SlotCoordinatorStandalone();
        SlotMessageCounter.getInstance().setSlotCoordinator(this.slotCoordinator);
        SlotDeliveryWorkerManager.getInstance().initialise(this.slotCoordinator);
    }

    public AndesMessagePart getMessageContentChunk(long messageID, int offsetInMessage) throws AndesException {
        return this.messageStore.getContent(messageID, offsetInMessage);
    }

    public LongObjectHashMap<List<AndesMessagePart>> getContent(LongArrayList messageIdList) throws AndesException {
        return this.messageStore.getContent(messageIdList);
    }

    public void messagesReceived(List<AndesMessage> messageList) throws AndesException {
        this.messageStore.storeMessages(messageList);
    }

    public AndesMessageMetadata getMessageMetaData(long messageID) throws AndesException {
        return this.messageStore.getMetadata(messageID);
    }

    public void moveMessageToDeadLetterChannel(DeliverableAndesMetadata messageToRemove, String destinationQueueName) throws AndesException {
        String deadLetterQueueName = DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(destinationQueueName);
        this.messageExpiryManager.moveMetadataToDLC(messageToRemove.getMessageID(), deadLetterQueueName);
        messageToRemove.markAsDLCMessage();
        messageToRemove.getSlot().decrementPendingMessageCount();
        MessageTracer.trace(messageToRemove.getMessageID(), destinationQueueName, "message moved to DLC");
    }

    public void deleteMessages(Collection<AndesMessageMetadata> messagesToRemove) throws AndesException {
        this.messageStore.deleteMessages(messagesToRemove);
    }

    public void deleteDLCMessages(List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        this.messageStore.deleteDLCMessages(messagesToRemove);
    }

    public void deleteMessages(List<DeliverableAndesMetadata> messagesToRemove) throws AndesException {
        this.markAsPreparedToDelete(messagesToRemove);
        this.messageStore.deleteMessages((Collection<? extends AndesMessageMetadata>)messagesToRemove);
        this.markAsDeleted(messagesToRemove);
    }

    private void markAsPreparedToDelete(List<DeliverableAndesMetadata> messagesToRemove) {
        for (DeliverableAndesMetadata message : messagesToRemove) {
            message.markAsPreparedToDelete();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Scheduled to delete message id= " + message.messageID));
        }
    }

    private void markAsDeleted(List<DeliverableAndesMetadata> messagesToRemove) {
        for (DeliverableAndesMetadata message : messagesToRemove) {
            message.markAsDeletedMessage();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Deleted message id= " + message.messageID));
        }
    }

    private Map<String, List<AndesMessageMetadata>> groupByStorageQueue(List<DeliverableAndesMetadata> messagesToRemove) {
        HashMap<String, List<AndesMessageMetadata>> storageSeparatedMessages = new HashMap<String, List<AndesMessageMetadata>>();
        for (DeliverableAndesMetadata message : messagesToRemove) {
            ArrayList<DeliverableAndesMetadata> messagesOfStorageQueue = (ArrayList<DeliverableAndesMetadata>)storageSeparatedMessages.get(message.getStorageQueueName());
            if (null == messagesOfStorageQueue) {
                messagesOfStorageQueue = new ArrayList<DeliverableAndesMetadata>();
            }
            messagesOfStorageQueue.add(message);
            storageSeparatedMessages.put(message.getStorageQueueName(), messagesOfStorageQueue);
        }
        return storageSeparatedMessages;
    }

    public List<AndesPreparedMessageMetadata> acknowledgeAndRetrieveDequeueRecords(List<AndesAckData> ackDataList) throws AndesException {
        ArrayList<AndesPreparedMessageMetadata> messagesToRemove = new ArrayList<AndesPreparedMessageMetadata>(ackDataList.size());
        for (AndesAckData ack : ackDataList) {
            AndesAckEvent ackEvent = new AndesAckEvent(ack);
            ackEvent.setMetadataReference();
            boolean deleteMessage = ackEvent.processEvent();
            if (!deleteMessage) continue;
            AndesPreparedMessageMetadata rollbackMessageMetadata = new AndesPreparedMessageMetadata(ackEvent.getMetadataReference());
            messagesToRemove.add(rollbackMessageMetadata);
        }
        return messagesToRemove;
    }

    public void deleteMessagesById(List<Long> messagesToRemove) throws AndesException {
        this.messageStore.deleteMessages(messagesToRemove);
    }

    public void moveMessageToDeadLetterChannel(List<DeliverableAndesMetadata> messagesToMove) throws AndesException {
        Map<String, List<AndesMessageMetadata>> storageSeparatedMessages = this.groupByStorageQueue(messagesToMove);
        for (Map.Entry<String, List<AndesMessageMetadata>> entry : storageSeparatedMessages.entrySet()) {
            String dlcQueueName = DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(entry.getKey());
            this.messageExpiryManager.moveMetadataToDLC(entry.getValue(), dlcQueueName);
        }
        for (DeliverableAndesMetadata message : messagesToMove) {
            message.markAsDLCMessage();
            message.getSlot().decrementPendingMessageCount();
        }
    }

    public void moveMessageToDeadLetterChannel(Collection<AndesMessageMetadata> messagesToMove) throws AndesException {
        HashMap<String, ArrayList<AndesMessageMetadata>> storageSeparatedMessages = new HashMap<String, ArrayList<AndesMessageMetadata>>();
        for (AndesMessageMetadata andesMessageMetadata : messagesToMove) {
            ArrayList<AndesMessageMetadata> messagesOfStorageQueue = (ArrayList<AndesMessageMetadata>)storageSeparatedMessages.get(andesMessageMetadata.getStorageQueueName());
            if (null == messagesOfStorageQueue) {
                messagesOfStorageQueue = new ArrayList<AndesMessageMetadata>();
            }
            messagesOfStorageQueue.add(andesMessageMetadata);
            storageSeparatedMessages.put(andesMessageMetadata.getStorageQueueName(), messagesOfStorageQueue);
        }
        for (Map.Entry entry : storageSeparatedMessages.entrySet()) {
            String dlcQueueName = DLCQueueUtils.identifyTenantInformationAndGenerateDLCString((String)entry.getKey());
            this.messageExpiryManager.moveMetadataToDLC((List)entry.getValue(), dlcQueueName);
        }
    }

    public AndesMessagePart getContent(long messageId, int offsetValue) throws AndesException {
        return this.messageStore.getContent(messageId, offsetValue);
    }

    public Map<String, Integer> getMessageCountForAllQueues(List<String> queueNames) throws AndesException {
        return this.messageStore.getMessageCountForAllQueues(queueNames);
    }

    public long getMessageCountOfQueue(String queueName) throws AndesException {
        return this.messageStore.getMessageCountForQueue(queueName);
    }

    public long getApproximateQueueMessageCount(String queueName) throws AndesException {
        return this.messageStore.getApproximateQueueMessageCount(queueName);
    }

    public long getMessageCountForQueueInRange(String storageQueueName, long firstMessageId, long lastMessageId) throws AndesException {
        return this.messageStore.getMessageCountForQueueInRange(storageQueueName, firstMessageId, lastMessageId);
    }

    public long getMessageCountInDLCForQueue(String queueName, String dlcQueueName) throws AndesException {
        return this.messageStore.getMessageCountForQueueInDLC(queueName, dlcQueueName);
    }

    public long getMessageCountInDLC(String dlcQueueName) throws AndesException {
        return this.messageStore.getMessageCountForDLCQueue(dlcQueueName);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataFromQueue(String queueName, long firstMsgId, int count) throws AndesException {
        return this.messageStore.getNextNMessageMetadataFromQueue(queueName, firstMsgId, count);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataInDLCForQueue(String queueName, String dlcQueueName, long firstMsgId, int count) throws AndesException {
        return this.messageStore.getNextNMessageMetadataForQueueFromDLC(queueName, dlcQueueName, firstMsgId, count);
    }

    public List<AndesMessageMetadata> getNextNMessageMetadataFromDLC(String dlcQueueName, long firstMsgId, int count) throws AndesException {
        return this.messageStore.getNextNMessageMetadataFromDLC(dlcQueueName, firstMsgId, count);
    }

    public List<Long> getExpiredMessages(long lowerBoundMessageID, String queueName) throws AndesException {
        return this.messageStore.getExpiredMessages(lowerBoundMessageID, queueName);
    }

    public List<Long> getExpiredMessagesFromDLC(long messageCount) throws AndesException {
        return this.messageStore.getExpiredMessagesFromDLC(messageCount);
    }

    public void updateMetaDataInformation(String currentQueueName, List<AndesMessageMetadata> metadataList) throws AndesException {
        this.messageStore.updateMetadataInformation(currentQueueName, metadataList);
    }

    public long generateUniqueId() {
        long messageId = this.messageIdGenerator.getNextId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("MessageID generated: " + messageId));
        }
        return messageId;
    }

    private void configureMessageIDGenerator() {
        String idGeneratorImpl = (String)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_ID_GENERATOR);
        if (idGeneratorImpl != null && !"".equals(idGeneratorImpl)) {
            try {
                Class<?> clz = Class.forName(idGeneratorImpl);
                Object o = clz.newInstance();
                this.messageIdGenerator = (MessageIdGenerator)o;
            }
            catch (Exception e) {
                log.error((Object)("Error while loading Message id generator implementation : " + idGeneratorImpl + " adding TimeStamp based implementation as the default"), (Throwable)e);
                this.messageIdGenerator = new TimeStampBasedMessageIdGenerator();
            }
        } else {
            this.messageIdGenerator = new TimeStampBasedMessageIdGenerator();
        }
    }

    public void startMessageDelivery() {
        log.info((Object)"Starting SlotDelivery Workers.");
        SlotDeliveryWorkerManager.getInstance().startMessageDelivery();
        log.info((Object)"Start Disruptor writing messages to store.");
    }

    public void stopMessageDelivery() {
        log.info((Object)"Stopping SlotDelivery Worker.");
        SlotDeliveryWorkerManager.getInstance().stopMessageDelivery();
        SlotMessageCounter.getInstance().stop();
        MessageFlusher.getInstance().stopMessageFlusher();
    }

    public void close() throws InterruptedException {
        this.stopMessageDelivery();
        this.completePendingStoreOperations();
    }

    public void completePendingStoreOperations() {
        this.messageStore.close();
    }

    public SlotCoordinator getSlotCoordinator() {
        return this.slotCoordinator;
    }

    public void storeRetainedMessages(Map<String, AndesMessage> retainMap) throws AndesException {
        this.messageStore.storeRetainedMessages(retainMap);
    }

    public List<DeliverableAndesMetadata> getRetainedMessageByTopic(String subscriptionTopicName) throws AndesException {
        ArrayList<DeliverableAndesMetadata> retainMessageList = new ArrayList<DeliverableAndesMetadata>();
        List<String> topicList = this.messageStore.getAllRetainedTopics();
        for (String topicName : topicList) {
            if (!TopicParserUtil.isMatching(topicName, subscriptionTopicName)) continue;
            retainMessageList.add(this.messageStore.getRetainedMetadata(topicName));
        }
        return retainMessageList;
    }

    public AndesContent getRetainedMessageContent(AndesMessageMetadata metadata) throws AndesException {
        long messageID = metadata.getMessageID();
        int contentSize = metadata.getMessageContentLength();
        Map<Integer, AndesMessagePart> retainedContentParts = this.messageStore.getRetainedContentParts(messageID);
        return new RetainedContent(retainedContentParts, contentSize, messageID);
    }

    public long getLastAssignedSlotMessageId(String queueName) throws AndesException {
        long lastMessageId = 0L;
        long messageIdDifference = 1310720000L;
        Long lastAssignedSlotMessageId = ClusterResourceHolder.getInstance().getClusterManager().isClusteringEnabled() ? SlotManagerClusterMode.getInstance().getLastAssignedSlotMessageIdInClusterMode(queueName) : SlotManagerStandalone.getInstance().getLastAssignedSlotMessageIdInStandaloneMode(queueName);
        if (lastAssignedSlotMessageId != null) {
            lastMessageId = lastAssignedSlotMessageId - messageIdDifference;
        }
        return lastMessageId;
    }

    public List<Long> getNextNMessageIdsInDLCForQueue(String sourceQueue, String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        return this.messageStore.getMessageIdsInDLCForQueue(sourceQueue, dlcQueueName, startMessageId, messageLimit);
    }

    public List<Long> getNextNMessageIdsInDLC(String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        return this.messageStore.getMessageIdsInDLC(dlcQueueName, startMessageId, messageLimit);
    }
}

