/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.EnumSet;
import java.util.List;

public enum MessageStatus {
    READ,
    BUFFERED,
    SCHEDULED_TO_SEND,
    ACKED_BY_ALL,
    SLOT_REMOVED,
    EXPIRED,
    NO_MATCHING_CONSUMER,
    DLC_MESSAGE,
    PURGED,
    PREPARED_TO_DELETE,
    DELETED,
    SLOT_RETURNED;

    private EnumSet<MessageStatus> next;
    private EnumSet<MessageStatus> previous;

    public boolean isValidNextTransition(MessageStatus nextState) {
        return this.next.contains((Object)nextState);
    }

    public boolean isValidPreviousState(MessageStatus previousState) {
        return this.previous.contains((Object)previousState);
    }

    public static boolean isOKToRemove(List<MessageStatus> messageStatus) {
        return messageStatus.contains((Object)EXPIRED) || messageStatus.contains((Object)DLC_MESSAGE) || messageStatus.contains((Object)PURGED) || messageStatus.contains((Object)DELETED) || messageStatus.get(messageStatus.size() - 1).equals((Object)SLOT_REMOVED) || messageStatus.get(messageStatus.size() - 1).equals((Object)SLOT_RETURNED);
    }

    static {
        MessageStatus.READ.next = EnumSet.of(BUFFERED, SLOT_RETURNED);
        MessageStatus.READ.previous = EnumSet.complementOf(EnumSet.allOf(MessageStatus.class));
        MessageStatus.BUFFERED.next = EnumSet.of(SCHEDULED_TO_SEND, NO_MATCHING_CONSUMER, SLOT_RETURNED);
        MessageStatus.BUFFERED.previous = EnumSet.of(READ);
        MessageStatus.NO_MATCHING_CONSUMER.next = EnumSet.of(DLC_MESSAGE);
        MessageStatus.NO_MATCHING_CONSUMER.previous = EnumSet.of(BUFFERED);
        MessageStatus.SCHEDULED_TO_SEND.next = EnumSet.of(EXPIRED, ACKED_BY_ALL, BUFFERED, DLC_MESSAGE, SLOT_RETURNED);
        MessageStatus.SCHEDULED_TO_SEND.previous = EnumSet.of(BUFFERED);
        MessageStatus.ACKED_BY_ALL.next = EnumSet.of(PREPARED_TO_DELETE, SLOT_RETURNED);
        MessageStatus.ACKED_BY_ALL.previous = EnumSet.of(SCHEDULED_TO_SEND);
        MessageStatus.EXPIRED.next = EnumSet.of(PREPARED_TO_DELETE, SLOT_RETURNED, DLC_MESSAGE);
        MessageStatus.EXPIRED.previous = EnumSet.allOf(MessageStatus.class);
        MessageStatus.DLC_MESSAGE.next = EnumSet.of(EXPIRED, BUFFERED, SLOT_REMOVED, SLOT_RETURNED);
        MessageStatus.DLC_MESSAGE.previous = EnumSet.of(SCHEDULED_TO_SEND);
        MessageStatus.PURGED.next = EnumSet.of(PREPARED_TO_DELETE, SLOT_RETURNED);
        MessageStatus.PURGED.previous = EnumSet.allOf(MessageStatus.class);
        MessageStatus.PREPARED_TO_DELETE.next = EnumSet.of(DELETED, SLOT_REMOVED);
        MessageStatus.PREPARED_TO_DELETE.previous = EnumSet.of(EXPIRED, DLC_MESSAGE, PURGED);
        MessageStatus.DELETED.next = EnumSet.of(SLOT_REMOVED, SLOT_RETURNED);
        MessageStatus.DELETED.previous = EnumSet.of(PREPARED_TO_DELETE, SLOT_REMOVED);
        MessageStatus.SLOT_REMOVED.next = EnumSet.of(DELETED, SLOT_RETURNED);
        MessageStatus.SLOT_REMOVED.previous = EnumSet.of(PREPARED_TO_DELETE, DELETED);
        MessageStatus.SLOT_RETURNED.next = EnumSet.allOf(MessageStatus.class);
        MessageStatus.SLOT_RETURNED.previous = EnumSet.allOf(MessageStatus.class);
    }
}

