/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotDeletionExecutor;
import org.wso2.andes.kernel.slot.SlotDeliveryWorkerManager;
import org.wso2.andes.kernel.slot.SlotReAssignTask;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.tools.utils.MessageTracer;

public class MessageHandler {
    private static Log log = LogFactory.getLog(MessageHandler.class);
    private MessageStore messageStore;
    private SlotDeliveryWorkerManager messageDeliveryManager;
    private String queueName;
    private static final int MAX_META_DATA_RETRIEVAL_COUNT = 5;
    private ConcurrentMap<Long, DeliverableAndesMetadata> readButUndeliveredMessages = new ConcurrentSkipListMap<Long, DeliverableAndesMetadata>();
    private Map<String, Slot> slotsRead;
    private long lastPurgedTimestamp;
    private Integer maxNumberOfReadButUndeliveredMessages;
    private final ExecutorService executor;

    public MessageHandler(String queueName) {
        this.queueName = queueName;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("AndesReleaseSlotTaskExecutor").build();
        this.executor = Executors.newSingleThreadExecutor(namedThreadFactory);
        this.maxNumberOfReadButUndeliveredMessages = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_DELIVERY_MAX_READ_BUT_UNDELIVERED_MESSAGES);
        this.messageDeliveryManager = SlotDeliveryWorkerManager.getInstance();
        this.lastPurgedTimestamp = 0L;
        this.messageStore = AndesContext.getInstance().getMessageStore();
        this.slotsRead = new ConcurrentHashMap<String, Slot>();
    }

    public void startMessageDelivery(StorageQueue queue) throws AndesException {
        this.messageDeliveryManager.startMessageDeliveryForQueue(queue);
    }

    public void stopMessageDelivery(StorageQueue queue) throws AndesException {
        this.messageDeliveryManager.stopDeliveryForQueue(queue);
    }

    public Long getLastPurgedTimestamp() {
        return this.lastPurgedTimestamp;
    }

    public int bufferMessages(Slot currentSlot) throws AndesException {
        Slot trackedSlot;
        List<DeliverableAndesMetadata> messagesReadFromStore = this.readMessagesFromMessageStore(currentSlot);
        if (messagesReadFromStore.isEmpty()) {
            SlotDeletionExecutor.getInstance().scheduleToDelete(currentSlot);
        }
        if ((trackedSlot = this.slotsRead.get(currentSlot.getId())) == null) {
            this.slotsRead.put(currentSlot.getId(), currentSlot);
            trackedSlot = currentSlot;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Overlapped slot received. Slot ID " + trackedSlot.getId()));
        }
        this.filterOverlappedMessages(trackedSlot, messagesReadFromStore);
        trackedSlot.incrementPendingMessageCount(messagesReadFromStore.size());
        for (DeliverableAndesMetadata message : messagesReadFromStore) {
            this.bufferMessage(message);
        }
        return messagesReadFromStore.size();
    }

    private List<DeliverableAndesMetadata> readMessagesFromMessageStore(Slot slot) throws AndesException {
        List<DeliverableAndesMetadata> messagesRead;
        int numberOfRetries = 0;
        try {
            messagesRead = this.messageStore.getMetadataList(slot, slot.getStorageQueueName(), slot.getStartMessageId(), slot.getEndMessageId());
            if (log.isDebugEnabled()) {
                StringBuilder messageIDString = new StringBuilder();
                for (DeliverableAndesMetadata metadata : messagesRead) {
                    messageIDString.append(metadata.getMessageID()).append(" , ");
                }
                log.debug((Object)("Messages Read: " + messageIDString));
            }
        }
        catch (AndesException aex) {
            if (++numberOfRetries <= 5) {
                String errorMsg = String.format("error occurred retrieving metadata list for slot : %s, retry count = %d", slot.toString(), numberOfRetries);
                log.error((Object)errorMsg, (Throwable)aex);
                messagesRead = this.messageStore.getMetadataList(slot, slot.getStorageQueueName(), slot.getStartMessageId(), slot.getEndMessageId());
            }
            String errorMsg = String.format("error occurred retrieving metadata list for slot : %s, in final attempt = %d. this slot will not be delivered and become stale in message store", slot.toString(), numberOfRetries);
            throw new AndesException(errorMsg, aex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of messages read from slot " + slot.getStartMessageId() + " - " + slot.getEndMessageId() + " is " + messagesRead.size() + " storage queue= " + slot.getStorageQueueName()));
        }
        return messagesRead;
    }

    private void filterOverlappedMessages(Slot slot, List<DeliverableAndesMetadata> messages) {
        Iterator<DeliverableAndesMetadata> readMessageIterator = messages.iterator();
        while (readMessageIterator.hasNext()) {
            DeliverableAndesMetadata currentMessage = readMessageIterator.next();
            if (slot.checkIfMessageIsAlreadyAdded(currentMessage.getMessageID())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tracker rejected message id= " + currentMessage.getMessageID() + " from buffering to deliver. This is an already buffered message"));
                }
                readMessageIterator.remove();
                continue;
            }
            currentMessage.changeSlot(slot);
            slot.addMessageToSlotIfAbsent(currentMessage);
        }
    }

    public Collection<DeliverableAndesMetadata> getReadButUndeliveredMessages() {
        return this.readButUndeliveredMessages.values();
    }

    public void bufferMessage(DeliverableAndesMetadata message) {
        this.readButUndeliveredMessages.putIfAbsent(message.getMessageID(), message);
        message.markAsBuffered();
        MessageTracer.trace(message, "metadata buffered for delivery");
    }

    public void removeBufferedMessage(long messageId) {
        this.readButUndeliveredMessages.remove(messageId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing scheduled to send message from buffer with id: " + messageId));
        }
    }

    public boolean messageBufferHasRoom() {
        boolean hasRoom = true;
        if (this.readButUndeliveredMessages.size() >= this.maxNumberOfReadButUndeliveredMessages) {
            hasRoom = false;
        }
        return hasRoom;
    }

    public int clearReadButUndeliveredMessages() {
        this.lastPurgedTimestamp = System.currentTimeMillis();
        int messageCount = this.readButUndeliveredMessages.size();
        this.readButUndeliveredMessages.clear();
        for (Slot slot : this.slotsRead.values()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("clear tracking of messages for slot = " + slot));
            }
            slot.markMessagesOfSlotAsReturned();
        }
        this.slotsRead.clear();
        return messageCount;
    }

    public int purgeMessagesOfQueue() throws AndesException {
        try {
            MessagingEngine.getInstance().getSlotCoordinator().clearAllActiveSlotRelationsToQueue(this.queueName);
            this.purgeInMemoryMessagesOfQueue();
            int deletedMessageCount = !DLCQueueUtils.isDeadLetterQueue(this.queueName) ? this.messageStore.deleteAllMessageMetadata(this.queueName) : this.messageStore.clearDLCQueue(this.queueName);
            return deletedMessageCount;
        }
        catch (AndesException e) {
            throw new AndesException("Error occurred when purging queue from store : " + this.queueName, e);
        }
    }

    public int purgeInMemoryMessagesOfQueue() {
        return this.clearReadButUndeliveredMessages();
    }

    public long getMessageCountForQueue() throws AndesException {
        long messageCount = !DLCQueueUtils.isDeadLetterQueue(this.queueName) ? this.messageStore.getMessageCountForQueue(this.queueName) : this.messageStore.getMessageCountForDLCQueue(this.queueName);
        return messageCount;
    }

    public void deleteSlot(Slot slotToDelete) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Releasing tracking of messages for slot " + slotToDelete.toString()));
        }
        slotToDelete.deleteAllMessagesInSlot();
        this.slotsRead.remove(slotToDelete.getId());
    }

    public void releaseAllSlots() {
        this.executor.submit(new SlotReAssignTask(this.queueName));
    }

    public void dumpAllSlotInformationToFile(File fileToWrite, String storageQueueName) throws AndesException {
        FileWriter information = null;
        try {
            information = new FileWriter(fileToWrite, true);
            for (Slot slot : this.slotsRead.values()) {
                List<DeliverableAndesMetadata> messagesOfSlot = slot.getAllMessagesOfSlot();
                if (messagesOfSlot.isEmpty()) continue;
                int writerFlushCounter = 0;
                for (DeliverableAndesMetadata message : messagesOfSlot) {
                    information.append(storageQueueName).append(",").append(slot.getId()).append(",").append(message.dumpMessageStatus()).append("\n");
                    if (++writerFlushCounter % 10 != 0) continue;
                    information.flush();
                }
                information.flush();
            }
            information.flush();
        }
        catch (FileNotFoundException e) {
            log.error((Object)"File to write is not found", (Throwable)e);
            throw new AndesException("File to write is not found", e);
        }
        catch (IOException e) {
            log.error((Object)"Error while dumping message status to file", (Throwable)e);
            throw new AndesException("Error while dumping message status to file", e);
        }
        finally {
            try {
                if (information != null) {
                    information.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while closing file when dumping message status to file", (Throwable)e);
            }
        }
    }
}

