/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.util.TopicMessageDeliveryStrategy;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DeliveryMessageHandler;
import org.wso2.andes.kernel.DeliveryResponsibility;
import org.wso2.andes.kernel.ExpiredMessageHandler;
import org.wso2.andes.kernel.FlowControlledQueueMessageDeliveryImpl;
import org.wso2.andes.kernel.MessageDeliveryStrategy;
import org.wso2.andes.kernel.NoLossBurstTopicMessageDeliveryImpl;
import org.wso2.andes.kernel.PreDeliveryExpiryMessageDeletionTask;
import org.wso2.andes.kernel.PurgedMessageHandler;
import org.wso2.andes.kernel.SlowestSubscriberTopicMessageDeliveryImpl;
import org.wso2.andes.kernel.disruptor.delivery.DisruptorBasedFlusher;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class MessageFlusher {
    private static Log log = LogFactory.getLog(MessageFlusher.class);
    private final DisruptorBasedFlusher flusherExecutor = new DisruptorBasedFlusher();
    private MessageDeliveryStrategy queueMessageFlusher = new FlowControlledQueueMessageDeliveryImpl();
    private MessageDeliveryStrategy topicMessageFlusher;
    private DeliveryResponsibility deliveryResponsibilityHead;
    private static MessageFlusher messageFlusher = new MessageFlusher();

    public static MessageFlusher getInstance() {
        return messageFlusher;
    }

    private MessageFlusher() {
        TopicMessageDeliveryStrategy topicMessageDeliveryStrategy = (TopicMessageDeliveryStrategy)((Object)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_TOPIC_MESSAGE_DELIVERY_STRATEGY));
        if (topicMessageDeliveryStrategy.equals((Object)TopicMessageDeliveryStrategy.DISCARD_ALLOWED) || topicMessageDeliveryStrategy.equals((Object)TopicMessageDeliveryStrategy.DISCARD_NONE)) {
            this.topicMessageFlusher = new NoLossBurstTopicMessageDeliveryImpl();
        } else if (topicMessageDeliveryStrategy.equals((Object)TopicMessageDeliveryStrategy.SLOWEST_SUB_RATE)) {
            this.topicMessageFlusher = new SlowestSubscriberTopicMessageDeliveryImpl();
        }
        this.initializeDeliveryResponsibilityComponents();
    }

    private void initializeDeliveryResponsibilityComponents() {
        this.deliveryResponsibilityHead = new PurgedMessageHandler();
        ExpiredMessageHandler expiredMessageHandler = new ExpiredMessageHandler();
        this.deliveryResponsibilityHead.setNextDeliveryFilter(expiredMessageHandler);
        expiredMessageHandler.setNextDeliveryFilter(new DeliveryMessageHandler());
        int preDeliveryDeletionTaskScheduledPeriod = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_PRE_DELIVERY_EXPIRY_DELETION_INTERVAL);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ExpiryMessageDeletionTask-%d").build();
        ScheduledExecutorService expiryMessageDeletionTaskScheduler = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        PreDeliveryExpiryMessageDeletionTask preDeliveryExpiryMessageDeletionTask = new PreDeliveryExpiryMessageDeletionTask();
        expiredMessageHandler.setExpiryMessageDeletionTask(preDeliveryExpiryMessageDeletionTask);
        expiryMessageDeletionTaskScheduler.scheduleAtFixedRate(preDeliveryExpiryMessageDeletionTask, preDeliveryDeletionTaskScheduledPeriod, preDeliveryDeletionTaskScheduledPeriod, TimeUnit.SECONDS);
    }

    public int sendMessagesToSubscriptions(StorageQueue storageQueue) throws AndesException {
        int noOfSentMessages = !storageQueue.isDurable() && (storageQueue.getMessageRouter().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME) || storageQueue.getMessageRouter().getName().equals("mqtt.topic")) ? this.topicMessageFlusher.deliverMessageToSubscriptions(storageQueue) : this.queueMessageFlusher.deliverMessageToSubscriptions(storageQueue);
        return noOfSentMessages;
    }

    public void scheduleMessageForSubscription(AndesSubscription subscription, DeliverableAndesMetadata message) throws AndesException {
        this.deliverMessageAsynchronously(subscription, message);
    }

    public void deliverMessageAsynchronously(AndesSubscription subscription, DeliverableAndesMetadata message) throws AndesException {
        this.deliveryResponsibilityHead.handleDeliveryMessage(subscription, message);
    }

    public void stopMessageFlusher() {
        this.flusherExecutor.stop();
    }

    public DisruptorBasedFlusher getFlusherExecutor() {
        return this.flusherExecutor;
    }
}

