/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.server.cluster.error.detection.HazelcastBasedNetworkPartitionDetector;

public class HazelcastLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(HazelcastLifecycleListener.class);
    private HazelcastBasedNetworkPartitionDetector networkPartitionDetector;

    public HazelcastLifecycleListener(HazelcastBasedNetworkPartitionDetector networkPartitionDetector) {
        this.networkPartitionDetector = networkPartitionDetector;
    }

    public void stateChanged(LifecycleEvent lifecycleEvent) {
        try {
            log.info((Object)("Hazelcast instance lifecycle changed state to " + lifecycleEvent.getState()));
            if (lifecycleEvent.getState() == LifecycleEvent.LifecycleState.MERGED) {
                log.info((Object)"Hazelcast cluster merge detected after a split brain. Updating unmerged data structures");
                AndesContext.getInstance().getClusterNotificationListenerManager().reInitializeListener();
                AndesSubscriptionManager andesSubscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
                if (null != andesSubscriptionManager) {
                    andesSubscriptionManager.updateSubscriptionsAfterClusterMerge();
                } else {
                    log.error((Object)"Andes Subscription Manager is not set. Local subscriptions are not synced with the main cluster");
                }
                this.networkPartitionDetector.networkPartitionMerged();
            } else if (lifecycleEvent.getState() == LifecycleEvent.LifecycleState.SHUTDOWN) {
                this.networkPartitionDetector.clusterOutageOccurred();
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error occurred while handling Hazelcast state change event " + lifecycleEvent.getState()), e);
        }
    }
}

