/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.MessageDeliveryStrategy;
import org.wso2.andes.kernel.MessageFlusher;
import org.wso2.andes.kernel.MessageStatus;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;

public class FlowControlledQueueMessageDeliveryImpl
implements MessageDeliveryStrategy {
    private static Log log = LogFactory.getLog(FlowControlledQueueMessageDeliveryImpl.class);

    @Override
    public int deliverMessageToSubscriptions(StorageQueue storageQueue) throws AndesException {
        Collection<DeliverableAndesMetadata> messages = storageQueue.getMessagesForDelivery();
        int sentMessageCount = 0;
        Iterator<DeliverableAndesMetadata> iterator = messages.iterator();
        List<AndesSubscription> subscriptions4Queue = storageQueue.getBoundSubscriptions();
        ArrayList<AndesSubscription> currentSubscriptions = new ArrayList<AndesSubscription>(subscriptions4Queue);
        int numOfConsumers = currentSubscriptions.size();
        int consumerIndexCounter = 0;
        while (iterator.hasNext()) {
            try {
                DeliverableAndesMetadata message = iterator.next();
                int numOfCurrentMsgDeliverySchedules = 0;
                boolean subscriberWithMatchingSelectorFound = true;
                boolean suspendedSubFound = false;
                for (int j = 0; j < numOfConsumers; ++j) {
                    int currentConsumerIndex = consumerIndexCounter % numOfConsumers;
                    AndesSubscription localSubscription = (AndesSubscription)currentSubscriptions.get(currentConsumerIndex);
                    ++consumerIndexCounter;
                    if (localSubscription.getSubscriberConnection().isSuspended()) {
                        suspendedSubFound = true;
                        continue;
                    }
                    if (!(localSubscription.getSubscriberConnection().hasRoomToAcceptMessages() & localSubscription.getSubscriberConnection().isReadyToDeliver())) continue;
                    if (!localSubscription.getSubscriberConnection().isMessageAcceptedByConnectionSelector(message)) {
                        subscriberWithMatchingSelectorFound = false;
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scheduled to send message id = " + message.getMessageID() + " to subscription id= " + localSubscription.getSubscriptionId()));
                    }
                    if (storageQueue.getMessageRouter().getName().equals(AMQPUtils.TOPIC_EXCHANGE_NAME) && storageQueue.isDurable()) {
                        message.setDestination(storageQueue.getName());
                    }
                    message.markAsScheduledToDeliver(localSubscription);
                    iterator.remove();
                    MessageFlusher.getInstance().deliverMessageAsynchronously(localSubscription, message);
                    ++numOfCurrentMsgDeliverySchedules;
                    break;
                }
                if (numOfCurrentMsgDeliverySchedules == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing Scheduled to send message from buffer. MsgId= " + message.getMessageID()));
                    }
                    ++sentMessageCount;
                    continue;
                }
                if (!subscriberWithMatchingSelectorFound && !suspendedSubFound) {
                    message.addMessageStatus(MessageStatus.NO_MATCHING_CONSUMER);
                    Andes.getInstance().moveMessageToDeadLetterChannel(message, message.getDestination());
                    iterator.remove();
                    continue;
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("All subscriptions bounded for queue " + storageQueue.getName() + " have reached number of max unacked messages, or are in the suspended state Skipping delivery of message id= " + message.getMessageID()));
            }
            catch (NoSuchElementException ex) {
                log.warn((Object)"NoSuchElementException thrown. ", (Throwable)ex);
            }
            break;
        }
        return sentMessageCount;
    }
}

