/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.kernel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.FlowControlListener;
import org.wso2.andes.server.cluster.error.detection.NetworkPartitionListener;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;

public class FlowControlManager
implements StoreHealthListener,
NetworkPartitionListener {
    private static Log log = LogFactory.getLog(FlowControlManager.class);
    private final int globalLowLimit;
    private final int globalHighLimit;
    private final ArrayList<AndesChannel> channels;
    private final ScheduledExecutorService executor;
    private final int channelHighLimit;
    private final int channelLowLimit;
    private AtomicInteger messagesOnGlobalBuffer;
    private boolean globalBufferBasedFlowControlEnabled;
    private volatile boolean globalErrorBasedFlowControlEnabled;
    private Runnable flowControlTimeoutTask = new BufferBasedFlowControlTimeoutTask();
    private ScheduledFuture<?> scheduledBufferBasedFlowControlTimeoutFuture;
    private boolean shutDownTriggered;

    public FlowControlManager() {
        this.globalLowLimit = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.FLOW_CONTROL_GLOBAL_LOW_LIMIT);
        this.globalHighLimit = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.FLOW_CONTROL_GLOBAL_HIGH_LIMIT);
        this.channelLowLimit = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.FLOW_CONTROL_BUFFER_BASED_LOW_LIMIT);
        this.channelHighLimit = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.FLOW_CONTROL_BUFFER_BASED_HIGH_LIMIT);
        if (this.globalHighLimit <= this.globalLowLimit || this.channelHighLimit <= this.channelLowLimit) {
            throw new RuntimeException("Flow Control limits are not configured correctly.");
        }
        this.messagesOnGlobalBuffer = new AtomicInteger(0);
        this.globalBufferBasedFlowControlEnabled = false;
        this.globalErrorBasedFlowControlEnabled = false;
        this.channels = new ArrayList();
        FailureObservingStoreManager.registerStoreHealthListener(this);
        if (AndesContext.getInstance().isClusteringEnabled()) {
            AndesContext.getInstance().getClusterAgent().addNetworkPartitionListener(20, this);
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("AndesScheduledTaskManager-FlowControl").build();
        this.executor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        MetricManager.gauge((String)"org.wso2.mb.channels.active.count", (Level)Level.INFO, (Gauge)new ChannelGauge());
    }

    public synchronized AndesChannel createChannel(String channelId, FlowControlListener listener) throws AndesException {
        if (this.globalErrorBasedFlowControlEnabled) {
            throw new AndesException("Global error based flow control is enabled. new connections are not allowed");
        }
        AndesChannel channel = new AndesChannel(this, channelId, listener, this.globalBufferBasedFlowControlEnabled, this.globalErrorBasedFlowControlEnabled);
        this.channels.add(channel);
        return channel;
    }

    public synchronized AndesChannel createChannel(FlowControlListener listener) {
        AndesChannel channel = new AndesChannel(this, listener, this.globalBufferBasedFlowControlEnabled, this.globalErrorBasedFlowControlEnabled);
        this.channels.add(channel);
        return channel;
    }

    public int getChannelHighLimit() {
        return this.channelHighLimit;
    }

    public int getChannelLowLimit() {
        return this.channelLowLimit;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.executor;
    }

    public void notifyAddition(int size) {
        int count = this.messagesOnGlobalBuffer.addAndGet(size);
        if (!this.globalBufferBasedFlowControlEnabled && count >= this.globalHighLimit) {
            this.blockListenersOnBufferBasedFlowControl();
        }
    }

    public void notifyRemoval(int size) {
        int count = this.messagesOnGlobalBuffer.addAndGet(-size);
        if (this.globalBufferBasedFlowControlEnabled && count <= this.globalLowLimit) {
            this.unblockListenersOnBufferBasedFlowControl();
        }
    }

    private synchronized void blockListenersOnBufferBasedFlowControl() {
        if (!this.globalBufferBasedFlowControlEnabled) {
            this.globalBufferBasedFlowControlEnabled = true;
            for (AndesChannel channel : this.channels) {
                channel.notifyGlobalBufferBasedFlowControlActivation();
            }
            this.scheduledBufferBasedFlowControlTimeoutFuture = this.executor.schedule(this.flowControlTimeoutTask, 1L, TimeUnit.MINUTES);
            log.info((Object)"Global buffer based flow control enabled.");
        }
    }

    private synchronized void unblockListenersOnBufferBasedFlowControl() {
        if (this.globalBufferBasedFlowControlEnabled && !this.shutDownTriggered) {
            this.scheduledBufferBasedFlowControlTimeoutFuture.cancel(false);
            this.globalBufferBasedFlowControlEnabled = false;
            for (AndesChannel channel : this.channels) {
                channel.notifyGlobalBufferBasedFlowControlDeactivation();
            }
            log.info((Object)"Global buffer based flow control disabled.");
        }
    }

    private synchronized void blockListenersOnErrorBasedFlowControl(boolean forcefullyDisconnect) {
        if (!this.globalErrorBasedFlowControlEnabled) {
            this.globalErrorBasedFlowControlEnabled = true;
            for (AndesChannel channel : this.channels) {
                channel.notifyGlobalErrorBasedFlowControlActivation();
            }
            log.info((Object)"Global error based flow control enabled.");
            if (forcefullyDisconnect) {
                ArrayList<AndesChannel> constantView = new ArrayList<AndesChannel>(this.channels);
                for (AndesChannel channel : constantView) {
                    try {
                        channel.disconnect();
                    }
                    catch (Exception exception) {
                        log.warn((Object)("Error occurred while disconnecting channel: " + channel.getId()));
                    }
                }
                log.info((Object)"Disconnected all clients due to store being non-operational.");
            }
        }
    }

    private synchronized void unblockListenersOnErrorBasedFlowControl() {
        if (this.globalErrorBasedFlowControlEnabled) {
            this.globalErrorBasedFlowControlEnabled = false;
            for (AndesChannel channel : this.channels) {
                channel.notifyGlobalErrorBasedFlowControlDeactivation();
            }
            log.info((Object)"Global error based flow control disabled.");
        }
    }

    public synchronized void deleteChannel(AndesChannel channel) {
        this.channels.remove(channel);
        log.info((Object)("Channel removed (ID: " + channel.getIdentifier() + ")"));
    }

    public synchronized void prepareChannelsForShutdown() {
        if (!this.globalErrorBasedFlowControlEnabled) {
            this.globalErrorBasedFlowControlEnabled = true;
            this.shutDownTriggered = true;
            log.info((Object)"Prepare channels for shutdown.");
            for (AndesChannel channel : this.channels) {
                channel.notifyGlobalBufferBasedFlowControlActivation();
            }
            this.scheduledBufferBasedFlowControlTimeoutFuture = this.executor.schedule(this.flowControlTimeoutTask, 1L, TimeUnit.MINUTES);
        }
    }

    @Override
    public void storeNonOperational(HealthAwareStore store, Exception ex) {
        log.warn((Object)"Stores became non-operational. Enabling error based flow control.");
        this.blockListenersOnErrorBasedFlowControl(true);
    }

    @Override
    public void storeOperational(HealthAwareStore store) {
        log.info((Object)"Stores became operational. Disabling error based flow control.");
        this.unblockListenersOnErrorBasedFlowControl();
    }

    @Override
    public void minimumNodeCountNotFulfilled(int currentNodeCount) {
        log.info((Object)"Network partition detected, activating error based flow control");
        this.blockListenersOnErrorBasedFlowControl(true);
    }

    @Override
    public void clusteringOutage() {
        log.warn((Object)"Clustering outage, activating error based flow control");
        this.blockListenersOnErrorBasedFlowControl(true);
    }

    @Override
    public void minimumNodeCountFulfilled(int currentNodeCount) {
        log.info((Object)"Network partition resolved, deactivating error based flow control");
        this.unblockListenersOnErrorBasedFlowControl();
    }

    private class ChannelGauge
    implements Gauge<Integer> {
        private ChannelGauge() {
        }

        public Integer getValue() {
            return FlowControlManager.this.channels.size();
        }
    }

    private class BufferBasedFlowControlTimeoutTask
    implements Runnable {
        private BufferBasedFlowControlTimeoutTask() {
        }

        @Override
        public void run() {
            if (FlowControlManager.this.globalBufferBasedFlowControlEnabled && FlowControlManager.this.messagesOnGlobalBuffer.get() <= FlowControlManager.this.globalLowLimit) {
                FlowControlManager.this.unblockListenersOnBufferBasedFlowControl();
            }
        }
    }
}

